/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.Format;
import software.amazon.awssdk.services.s3control.model.OutputSchemaVersion;
import software.amazon.awssdk.services.s3control.model.StorageLensDataExportEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketDestination> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(S3BucketDestination.getter(S3BucketDestination::formatAsString)).setter(S3BucketDestination.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<String> OUTPUT_SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSchemaVersion").getter(S3BucketDestination.getter(S3BucketDestination::outputSchemaVersionAsString)).setter(S3BucketDestination.setter(Builder::outputSchemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemaVersion").unmarshallLocationName("OutputSchemaVersion").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(S3BucketDestination.getter(S3BucketDestination::accountId)).setter(S3BucketDestination.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").unmarshallLocationName("AccountId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(S3BucketDestination.getter(S3BucketDestination::arn)).setter(S3BucketDestination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(S3BucketDestination.getter(S3BucketDestination::prefix)).setter(S3BucketDestination.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build();
    private static final SdkField<StorageLensDataExportEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(S3BucketDestination.getter(S3BucketDestination::encryption)).setter(S3BucketDestination.setter(Builder::encryption)).constructor(StorageLensDataExportEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").unmarshallLocationName("Encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, OUTPUT_SCHEMA_VERSION_FIELD, ACCOUNT_ID_FIELD, ARN_FIELD, PREFIX_FIELD, ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String outputSchemaVersion;
    private final String accountId;
    private final String arn;
    private final String prefix;
    private final StorageLensDataExportEncryption encryption;

    private S3BucketDestination(BuilderImpl builder) {
        this.format = builder.format;
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.prefix = builder.prefix;
        this.encryption = builder.encryption;
    }

    public Format format() {
        return Format.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public OutputSchemaVersion outputSchemaVersion() {
        return OutputSchemaVersion.fromValue(this.outputSchemaVersion);
    }

    public String outputSchemaVersionAsString() {
        return this.outputSchemaVersion;
    }

    public String accountId() {
        return this.accountId;
    }

    public String arn() {
        return this.arn;
    }

    public String prefix() {
        return this.prefix;
    }

    public StorageLensDataExportEncryption encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSchemaVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDestination)) {
            return false;
        }
        S3BucketDestination other = (S3BucketDestination)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.outputSchemaVersionAsString(), other.outputSchemaVersionAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.encryption(), other.encryption());
    }

    public String toString() {
        return ToString.builder((String)"S3BucketDestination").add("Format", (Object)this.formatAsString()).add("OutputSchemaVersion", (Object)this.outputSchemaVersionAsString()).add("AccountId", (Object)this.accountId()).add("Arn", (Object)this.arn()).add("Prefix", (Object)this.prefix()).add("Encryption", (Object)this.encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "OutputSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.outputSchemaVersionAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDestination, T> g) {
        return obj -> g.apply((S3BucketDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String outputSchemaVersion;
        private String accountId;
        private String arn;
        private String prefix;
        private StorageLensDataExportEncryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDestination model) {
            this.format(model.format);
            this.outputSchemaVersion(model.outputSchemaVersion);
            this.accountId(model.accountId);
            this.arn(model.arn);
            this.prefix(model.prefix);
            this.encryption(model.encryption);
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getOutputSchemaVersion() {
            return this.outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(OutputSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion == null ? null : outputSchemaVersion.toString());
            return this;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final StorageLensDataExportEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(StorageLensDataExportEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(StorageLensDataExportEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public S3BucketDestination build() {
            return new S3BucketDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketDestination> {
        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder outputSchemaVersion(String var1);

        public Builder outputSchemaVersion(OutputSchemaVersion var1);

        public Builder accountId(String var1);

        public Builder arn(String var1);

        public Builder prefix(String var1);

        public Builder encryption(StorageLensDataExportEncryption var1);

        default public Builder encryption(Consumer<StorageLensDataExportEncryption.Builder> encryption) {
            return this.encryption((StorageLensDataExportEncryption)((StorageLensDataExportEncryption.Builder)StorageLensDataExportEncryption.builder().applyMutation(encryption)).build());
        }
    }
}

