/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStorageLensConfigurationRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, DeleteStorageLensConfigurationRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigId").getter(DeleteStorageLensConfigurationRequest.getter(DeleteStorageLensConfigurationRequest::configId)).setter(DeleteStorageLensConfigurationRequest.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("storagelensid").unmarshallLocationName("storagelensid").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DeleteStorageLensConfigurationRequest.getter(DeleteStorageLensConfigurationRequest::accountId)).setter(DeleteStorageLensConfigurationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, ACCOUNT_ID_FIELD));
    private final String configId;
    private final String accountId;

    private DeleteStorageLensConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.accountId = builder.accountId;
    }

    public String configId() {
        return this.configId;
    }

    public String accountId() {
        return this.accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStorageLensConfigurationRequest)) {
            return false;
        }
        DeleteStorageLensConfigurationRequest other = (DeleteStorageLensConfigurationRequest)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.accountId(), other.accountId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteStorageLensConfigurationRequest").add("ConfigId", (Object)this.configId()).add("AccountId", (Object)this.accountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteStorageLensConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteStorageLensConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String configId;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStorageLensConfigurationRequest model) {
            super(model);
            this.configId(model.configId);
            this.accountId(model.accountId);
        }

        public final String getConfigId() {
            return this.configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStorageLensConfigurationRequest build() {
            return new DeleteStorageLensConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteStorageLensConfigurationRequest> {
        public Builder configId(String var1);

        public Builder accountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

