/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.BucketsCopier;
import software.amazon.awssdk.services.s3control.model.RegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Exclude
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Exclude> {
    private static final SdkField<List<String>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Buckets").getter(Exclude.getter(Exclude::buckets)).setter(Exclude.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Buckets").unmarshallLocationName("Buckets").build(), ListTrait.builder().memberLocationName("Arn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(Exclude.getter(Exclude::regions)).setter(Exclude.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").unmarshallLocationName("Regions").build(), ListTrait.builder().memberLocationName("Region").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD, REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> buckets;
    private final List<String> regions;

    private Exclude(BuilderImpl builder) {
        this.buckets = builder.buckets;
        this.regions = builder.regions;
    }

    public boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public List<String> buckets() {
        return this.buckets;
    }

    public boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Exclude)) {
            return false;
        }
        Exclude other = (Exclude)obj;
        return this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public String toString() {
        return ToString.builder((String)"Exclude").add("Buckets", this.hasBuckets() ? this.buckets() : null).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Exclude, T> g) {
        return obj -> g.apply((Exclude)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> buckets = DefaultSdkAutoConstructList.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Exclude model) {
            this.buckets(model.buckets);
            this.regions(model.regions);
        }

        public final Collection<String> getBuckets() {
            if (this.buckets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buckets;
        }

        @Override
        public final Builder buckets(Collection<String> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(String ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        public final void setBuckets(Collection<String> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        public Exclude build() {
            return new Exclude(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Exclude> {
        public Builder buckets(Collection<String> var1);

        public Builder buckets(String ... var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

