/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.internal.resource.S3OutpostResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.internal.usearnregion.UseArnRegionProviderChain;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.services.s3control.internal.HandlerUtils;
import software.amazon.awssdk.services.s3control.internal.S3ControlArnConverter;

@SdkInternalApi
public final class ArnHandler {
    private static final String X_AMZ_OUTPOST_ID_HEADER = "x-amz-outpost-id";
    private static final ArnHandler INSTANCE = new ArnHandler();
    private static final UseArnRegionProviderChain USE_ARN_REGION_RESOLVER = UseArnRegionProviderChain.create();

    private ArnHandler() {
    }

    public static ArnHandler getInstance() {
        return INSTANCE;
    }

    public SdkHttpRequest resolveHostForArn(SdkHttpRequest request, S3ControlConfiguration configuration, Arn arn, ExecutionAttributes executionAttributes) {
        S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
        String clientRegion = ((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION)).id();
        String originalArnRegion = (String)s3Resource.region().orElseThrow(() -> new IllegalArgumentException("Region is missing"));
        boolean isFipsEnabled = HandlerUtils.isFipsEnabledInClientConfig(configuration) || HandlerUtils.isFipsRegionProvided(clientRegion, originalArnRegion, this.useArnRegion(configuration));
        String arnRegion = this.removeFipsIfNeeded(originalArnRegion);
        this.validateConfiguration(executionAttributes, arn.partition(), arnRegion, configuration);
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SIGNING_REGION, (Object)Region.of((String)arnRegion));
        S3Resource parentS3Resource = s3Resource.parentS3Resource().orElse(null);
        if (parentS3Resource instanceof S3OutpostResource) {
            return this.handleOutpostArn(request, (S3OutpostResource)parentS3Resource, isFipsEnabled, configuration, executionAttributes);
        }
        throw new IllegalArgumentException("Parent resource invalid, outpost resource expected.");
    }

    private SdkHttpRequest handleOutpostArn(SdkHttpRequest request, S3OutpostResource outpostResource, boolean isFipsEnabled, S3ControlConfiguration configuration, ExecutionAttributes executionAttributes) {
        if (isFipsEnabled) {
            throw new IllegalArgumentException("FIPS endpoints are not supported for outpost ARNs");
        }
        if (HandlerUtils.isDualstackEnabled(configuration)) {
            throw new IllegalArgumentException("Dualstack endpoints are not supported for outpost ARNs");
        }
        executionAttributes.putAttribute(AwsSignerExecutionAttribute.SERVICE_SIGNING_NAME, (Object)"s3-outposts");
        SdkHttpRequest.Builder requestBuilder = ((SdkHttpRequest.Builder)request.toBuilder()).appendHeader(X_AMZ_OUTPOST_ID_HEADER, outpostResource.outpostId());
        String arnRegion = (String)outpostResource.region().orElseThrow(() -> new IllegalArgumentException("arn region is missing"));
        String dnsSuffix = PartitionMetadata.of((Region)Region.of((String)arnRegion)).dnsSuffix();
        String host = String.format("s3-outposts.%s.%s", arnRegion, dnsSuffix);
        return (SdkHttpRequest)requestBuilder.host(host).build();
    }

    private void validateConfiguration(ExecutionAttributes executionAttributes, String arnPartition, String arnRegion, S3ControlConfiguration configuration) {
        String clientRegionString = this.removeFipsIfNeeded(((Region)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SIGNING_REGION)).id());
        Region clientRegion = Region.of((String)clientRegionString);
        if (Boolean.TRUE.equals(executionAttributes.getAttribute(SdkExecutionAttribute.ENDPOINT_OVERRIDDEN))) {
            throw new IllegalArgumentException("An ARN cannot be passed to an  operation if the client has been configured with an endpoint override.");
        }
        String clientPartition = PartitionMetadata.of((Region)clientRegion).id();
        if (!arnPartition.equals(clientPartition)) {
            throw new IllegalArgumentException("The partition field of the ARN being passed as a bucket parameter to an S3 operation does not match the partition the client has been configured with. Provided partition: '" + arnPartition + "'; client partition: '" + clientPartition + "'.");
        }
        if (!arnRegion.equals(clientRegionString) && !this.useArnRegion(configuration)) {
            throw new IllegalArgumentException("The region field of the ARN being passed as a bucket parameter to an operation does not match the region the client was configured with. Provided region: '" + arnRegion + "'; client region: '" + clientRegionString + "'.");
        }
    }

    private String removeFipsIfNeeded(String region) {
        if (region.startsWith("fips-")) {
            return region.replace("fips-", "");
        }
        if (region.endsWith("-fips")) {
            return region.replace("-fips", "");
        }
        return region;
    }

    private boolean useArnRegion(S3ControlConfiguration configuration) {
        if (HandlerUtils.isUseArnRegionEnabledInClientConfig(configuration)) {
            return true;
        }
        return USE_ARN_REGION_RESOLVER.resolveUseArnRegion().orElse(false);
    }
}

