/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.S3CannedAccessControlList;
import software.amazon.awssdk.services.s3control.model.S3Grant;
import software.amazon.awssdk.services.s3control.model.S3GrantListCopier;
import software.amazon.awssdk.services.s3control.model.S3MetadataDirective;
import software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3control.model.S3ObjectLockMode;
import software.amazon.awssdk.services.s3control.model.S3ObjectMetadata;
import software.amazon.awssdk.services.s3control.model.S3StorageClass;
import software.amazon.awssdk.services.s3control.model.S3Tag;
import software.amazon.awssdk.services.s3control.model.S3TagSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3CopyObjectOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3CopyObjectOperation> {
    private static final SdkField<String> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::targetResource)).setter(S3CopyObjectOperation.setter(Builder::targetResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResource").unmarshallLocationName("TargetResource").build()}).build();
    private static final SdkField<String> CANNED_ACCESS_CONTROL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::cannedAccessControlListAsString)).setter(S3CopyObjectOperation.setter(Builder::cannedAccessControlList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAccessControlList").unmarshallLocationName("CannedAccessControlList").build()}).build();
    private static final SdkField<List<S3Grant>> ACCESS_CONTROL_GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::accessControlGrants)).setter(S3CopyObjectOperation.setter(Builder::accessControlGrants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlGrants").unmarshallLocationName("AccessControlGrants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Grant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METADATA_DIRECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::metadataDirectiveAsString)).setter(S3CopyObjectOperation.setter(Builder::metadataDirective)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataDirective").unmarshallLocationName("MetadataDirective").build()}).build();
    private static final SdkField<Instant> MODIFIED_SINCE_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::modifiedSinceConstraint)).setter(S3CopyObjectOperation.setter(Builder::modifiedSinceConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedSinceConstraint").unmarshallLocationName("ModifiedSinceConstraint").build()}).build();
    private static final SdkField<S3ObjectMetadata> NEW_OBJECT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::newObjectMetadata)).setter(S3CopyObjectOperation.setter(Builder::newObjectMetadata)).constructor(S3ObjectMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewObjectMetadata").unmarshallLocationName("NewObjectMetadata").build()}).build();
    private static final SdkField<List<S3Tag>> NEW_OBJECT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::newObjectTagging)).setter(S3CopyObjectOperation.setter(Builder::newObjectTagging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewObjectTagging").unmarshallLocationName("NewObjectTagging").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::redirectLocation)).setter(S3CopyObjectOperation.setter(Builder::redirectLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectLocation").unmarshallLocationName("RedirectLocation").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::requesterPays)).setter(S3CopyObjectOperation.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").unmarshallLocationName("RequesterPays").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::storageClassAsString)).setter(S3CopyObjectOperation.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").unmarshallLocationName("StorageClass").build()}).build();
    private static final SdkField<Instant> UN_MODIFIED_SINCE_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::unModifiedSinceConstraint)).setter(S3CopyObjectOperation.setter(Builder::unModifiedSinceConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnModifiedSinceConstraint").unmarshallLocationName("UnModifiedSinceConstraint").build()}).build();
    private static final SdkField<String> SSE_AWS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::sseAwsKmsKeyId)).setter(S3CopyObjectOperation.setter(Builder::sseAwsKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAwsKmsKeyId").unmarshallLocationName("SSEAwsKmsKeyId").build()}).build();
    private static final SdkField<String> TARGET_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::targetKeyPrefix)).setter(S3CopyObjectOperation.setter(Builder::targetKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetKeyPrefix").unmarshallLocationName("TargetKeyPrefix").build()}).build();
    private static final SdkField<String> OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockLegalHoldStatusAsString)).setter(S3CopyObjectOperation.setter(Builder::objectLockLegalHoldStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockLegalHoldStatus").unmarshallLocationName("ObjectLockLegalHoldStatus").build()}).build();
    private static final SdkField<String> OBJECT_LOCK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockModeAsString)).setter(S3CopyObjectOperation.setter(Builder::objectLockMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockMode").unmarshallLocationName("ObjectLockMode").build()}).build();
    private static final SdkField<Instant> OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(S3CopyObjectOperation.getter(S3CopyObjectOperation::objectLockRetainUntilDate)).setter(S3CopyObjectOperation.setter(Builder::objectLockRetainUntilDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLockRetainUntilDate").unmarshallLocationName("ObjectLockRetainUntilDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_FIELD, CANNED_ACCESS_CONTROL_LIST_FIELD, ACCESS_CONTROL_GRANTS_FIELD, METADATA_DIRECTIVE_FIELD, MODIFIED_SINCE_CONSTRAINT_FIELD, NEW_OBJECT_METADATA_FIELD, NEW_OBJECT_TAGGING_FIELD, REDIRECT_LOCATION_FIELD, REQUESTER_PAYS_FIELD, STORAGE_CLASS_FIELD, UN_MODIFIED_SINCE_CONSTRAINT_FIELD, SSE_AWS_KMS_KEY_ID_FIELD, TARGET_KEY_PREFIX_FIELD, OBJECT_LOCK_LEGAL_HOLD_STATUS_FIELD, OBJECT_LOCK_MODE_FIELD, OBJECT_LOCK_RETAIN_UNTIL_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetResource;
    private final String cannedAccessControlList;
    private final List<S3Grant> accessControlGrants;
    private final String metadataDirective;
    private final Instant modifiedSinceConstraint;
    private final S3ObjectMetadata newObjectMetadata;
    private final List<S3Tag> newObjectTagging;
    private final String redirectLocation;
    private final Boolean requesterPays;
    private final String storageClass;
    private final Instant unModifiedSinceConstraint;
    private final String sseAwsKmsKeyId;
    private final String targetKeyPrefix;
    private final String objectLockLegalHoldStatus;
    private final String objectLockMode;
    private final Instant objectLockRetainUntilDate;

    private S3CopyObjectOperation(BuilderImpl builder) {
        this.targetResource = builder.targetResource;
        this.cannedAccessControlList = builder.cannedAccessControlList;
        this.accessControlGrants = builder.accessControlGrants;
        this.metadataDirective = builder.metadataDirective;
        this.modifiedSinceConstraint = builder.modifiedSinceConstraint;
        this.newObjectMetadata = builder.newObjectMetadata;
        this.newObjectTagging = builder.newObjectTagging;
        this.redirectLocation = builder.redirectLocation;
        this.requesterPays = builder.requesterPays;
        this.storageClass = builder.storageClass;
        this.unModifiedSinceConstraint = builder.unModifiedSinceConstraint;
        this.sseAwsKmsKeyId = builder.sseAwsKmsKeyId;
        this.targetKeyPrefix = builder.targetKeyPrefix;
        this.objectLockLegalHoldStatus = builder.objectLockLegalHoldStatus;
        this.objectLockMode = builder.objectLockMode;
        this.objectLockRetainUntilDate = builder.objectLockRetainUntilDate;
    }

    public String targetResource() {
        return this.targetResource;
    }

    public S3CannedAccessControlList cannedAccessControlList() {
        return S3CannedAccessControlList.fromValue(this.cannedAccessControlList);
    }

    public String cannedAccessControlListAsString() {
        return this.cannedAccessControlList;
    }

    public boolean hasAccessControlGrants() {
        return this.accessControlGrants != null && !(this.accessControlGrants instanceof SdkAutoConstructList);
    }

    public List<S3Grant> accessControlGrants() {
        return this.accessControlGrants;
    }

    public S3MetadataDirective metadataDirective() {
        return S3MetadataDirective.fromValue(this.metadataDirective);
    }

    public String metadataDirectiveAsString() {
        return this.metadataDirective;
    }

    public Instant modifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public S3ObjectMetadata newObjectMetadata() {
        return this.newObjectMetadata;
    }

    public boolean hasNewObjectTagging() {
        return this.newObjectTagging != null && !(this.newObjectTagging instanceof SdkAutoConstructList);
    }

    public List<S3Tag> newObjectTagging() {
        return this.newObjectTagging;
    }

    public String redirectLocation() {
        return this.redirectLocation;
    }

    public Boolean requesterPays() {
        return this.requesterPays;
    }

    public S3StorageClass storageClass() {
        return S3StorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public Instant unModifiedSinceConstraint() {
        return this.unModifiedSinceConstraint;
    }

    public String sseAwsKmsKeyId() {
        return this.sseAwsKmsKeyId;
    }

    public String targetKeyPrefix() {
        return this.targetKeyPrefix;
    }

    public S3ObjectLockLegalHoldStatus objectLockLegalHoldStatus() {
        return S3ObjectLockLegalHoldStatus.fromValue(this.objectLockLegalHoldStatus);
    }

    public String objectLockLegalHoldStatusAsString() {
        return this.objectLockLegalHoldStatus;
    }

    public S3ObjectLockMode objectLockMode() {
        return S3ObjectLockMode.fromValue(this.objectLockMode);
    }

    public String objectLockModeAsString() {
        return this.objectLockMode;
    }

    public Instant objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cannedAccessControlListAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControlGrants());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataDirectiveAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedSinceConstraint());
        hashCode = 31 * hashCode + Objects.hashCode(this.newObjectMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.newObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unModifiedSinceConstraint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseAwsKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockLegalHoldStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLockRetainUntilDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CopyObjectOperation)) {
            return false;
        }
        S3CopyObjectOperation other = (S3CopyObjectOperation)obj;
        return Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.cannedAccessControlListAsString(), other.cannedAccessControlListAsString()) && Objects.equals(this.accessControlGrants(), other.accessControlGrants()) && Objects.equals(this.metadataDirectiveAsString(), other.metadataDirectiveAsString()) && Objects.equals(this.modifiedSinceConstraint(), other.modifiedSinceConstraint()) && Objects.equals(this.newObjectMetadata(), other.newObjectMetadata()) && Objects.equals(this.newObjectTagging(), other.newObjectTagging()) && Objects.equals(this.redirectLocation(), other.redirectLocation()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.unModifiedSinceConstraint(), other.unModifiedSinceConstraint()) && Objects.equals(this.sseAwsKmsKeyId(), other.sseAwsKmsKeyId()) && Objects.equals(this.targetKeyPrefix(), other.targetKeyPrefix()) && Objects.equals(this.objectLockLegalHoldStatusAsString(), other.objectLockLegalHoldStatusAsString()) && Objects.equals(this.objectLockModeAsString(), other.objectLockModeAsString()) && Objects.equals(this.objectLockRetainUntilDate(), other.objectLockRetainUntilDate());
    }

    public String toString() {
        return ToString.builder((String)"S3CopyObjectOperation").add("TargetResource", (Object)this.targetResource()).add("CannedAccessControlList", (Object)this.cannedAccessControlListAsString()).add("AccessControlGrants", this.accessControlGrants()).add("MetadataDirective", (Object)this.metadataDirectiveAsString()).add("ModifiedSinceConstraint", (Object)this.modifiedSinceConstraint()).add("NewObjectMetadata", (Object)this.newObjectMetadata()).add("NewObjectTagging", this.newObjectTagging()).add("RedirectLocation", (Object)this.redirectLocation()).add("RequesterPays", (Object)this.requesterPays()).add("StorageClass", (Object)this.storageClassAsString()).add("UnModifiedSinceConstraint", (Object)this.unModifiedSinceConstraint()).add("SSEAwsKmsKeyId", (Object)this.sseAwsKmsKeyId()).add("TargetKeyPrefix", (Object)this.targetKeyPrefix()).add("ObjectLockLegalHoldStatus", (Object)this.objectLockLegalHoldStatusAsString()).add("ObjectLockMode", (Object)this.objectLockModeAsString()).add("ObjectLockRetainUntilDate", (Object)this.objectLockRetainUntilDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "CannedAccessControlList": {
                return Optional.ofNullable(clazz.cast(this.cannedAccessControlListAsString()));
            }
            case "AccessControlGrants": {
                return Optional.ofNullable(clazz.cast(this.accessControlGrants()));
            }
            case "MetadataDirective": {
                return Optional.ofNullable(clazz.cast(this.metadataDirectiveAsString()));
            }
            case "ModifiedSinceConstraint": {
                return Optional.ofNullable(clazz.cast(this.modifiedSinceConstraint()));
            }
            case "NewObjectMetadata": {
                return Optional.ofNullable(clazz.cast(this.newObjectMetadata()));
            }
            case "NewObjectTagging": {
                return Optional.ofNullable(clazz.cast(this.newObjectTagging()));
            }
            case "RedirectLocation": {
                return Optional.ofNullable(clazz.cast(this.redirectLocation()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "UnModifiedSinceConstraint": {
                return Optional.ofNullable(clazz.cast(this.unModifiedSinceConstraint()));
            }
            case "SSEAwsKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseAwsKmsKeyId()));
            }
            case "TargetKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.targetKeyPrefix()));
            }
            case "ObjectLockLegalHoldStatus": {
                return Optional.ofNullable(clazz.cast(this.objectLockLegalHoldStatusAsString()));
            }
            case "ObjectLockMode": {
                return Optional.ofNullable(clazz.cast(this.objectLockModeAsString()));
            }
            case "ObjectLockRetainUntilDate": {
                return Optional.ofNullable(clazz.cast(this.objectLockRetainUntilDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3CopyObjectOperation, T> g) {
        return obj -> g.apply((S3CopyObjectOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetResource;
        private String cannedAccessControlList;
        private List<S3Grant> accessControlGrants = DefaultSdkAutoConstructList.getInstance();
        private String metadataDirective;
        private Instant modifiedSinceConstraint;
        private S3ObjectMetadata newObjectMetadata;
        private List<S3Tag> newObjectTagging = DefaultSdkAutoConstructList.getInstance();
        private String redirectLocation;
        private Boolean requesterPays;
        private String storageClass;
        private Instant unModifiedSinceConstraint;
        private String sseAwsKmsKeyId;
        private String targetKeyPrefix;
        private String objectLockLegalHoldStatus;
        private String objectLockMode;
        private Instant objectLockRetainUntilDate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3CopyObjectOperation model) {
            this.targetResource(model.targetResource);
            this.cannedAccessControlList(model.cannedAccessControlList);
            this.accessControlGrants(model.accessControlGrants);
            this.metadataDirective(model.metadataDirective);
            this.modifiedSinceConstraint(model.modifiedSinceConstraint);
            this.newObjectMetadata(model.newObjectMetadata);
            this.newObjectTagging(model.newObjectTagging);
            this.redirectLocation(model.redirectLocation);
            this.requesterPays(model.requesterPays);
            this.storageClass(model.storageClass);
            this.unModifiedSinceConstraint(model.unModifiedSinceConstraint);
            this.sseAwsKmsKeyId(model.sseAwsKmsKeyId);
            this.targetKeyPrefix(model.targetKeyPrefix);
            this.objectLockLegalHoldStatus(model.objectLockLegalHoldStatus);
            this.objectLockMode(model.objectLockMode);
            this.objectLockRetainUntilDate(model.objectLockRetainUntilDate);
        }

        public final String getTargetResource() {
            return this.targetResource;
        }

        @Override
        public final Builder targetResource(String targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final void setTargetResource(String targetResource) {
            this.targetResource = targetResource;
        }

        public final String getCannedAccessControlList() {
            return this.cannedAccessControlList;
        }

        @Override
        public final Builder cannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
            return this;
        }

        @Override
        public final Builder cannedAccessControlList(S3CannedAccessControlList cannedAccessControlList) {
            this.cannedAccessControlList(cannedAccessControlList == null ? null : cannedAccessControlList.toString());
            return this;
        }

        public final void setCannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
        }

        public final Collection<S3Grant.Builder> getAccessControlGrants() {
            return this.accessControlGrants != null ? (Collection)this.accessControlGrants.stream().map(S3Grant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessControlGrants(Collection<S3Grant> accessControlGrants) {
            this.accessControlGrants = S3GrantListCopier.copy(accessControlGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlGrants(S3Grant ... accessControlGrants) {
            this.accessControlGrants(Arrays.asList(accessControlGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlGrants(Consumer<S3Grant.Builder> ... accessControlGrants) {
            this.accessControlGrants(Stream.of(accessControlGrants).map(c -> (S3Grant)((S3Grant.Builder)S3Grant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessControlGrants(Collection<S3Grant.BuilderImpl> accessControlGrants) {
            this.accessControlGrants = S3GrantListCopier.copyFromBuilder(accessControlGrants);
        }

        public final String getMetadataDirective() {
            return this.metadataDirective;
        }

        @Override
        public final Builder metadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        @Override
        public final Builder metadataDirective(S3MetadataDirective metadataDirective) {
            this.metadataDirective(metadataDirective == null ? null : metadataDirective.toString());
            return this;
        }

        public final void setMetadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
        }

        public final Instant getModifiedSinceConstraint() {
            return this.modifiedSinceConstraint;
        }

        @Override
        public final Builder modifiedSinceConstraint(Instant modifiedSinceConstraint) {
            this.modifiedSinceConstraint = modifiedSinceConstraint;
            return this;
        }

        public final void setModifiedSinceConstraint(Instant modifiedSinceConstraint) {
            this.modifiedSinceConstraint = modifiedSinceConstraint;
        }

        public final S3ObjectMetadata.Builder getNewObjectMetadata() {
            return this.newObjectMetadata != null ? this.newObjectMetadata.toBuilder() : null;
        }

        @Override
        public final Builder newObjectMetadata(S3ObjectMetadata newObjectMetadata) {
            this.newObjectMetadata = newObjectMetadata;
            return this;
        }

        public final void setNewObjectMetadata(S3ObjectMetadata.BuilderImpl newObjectMetadata) {
            this.newObjectMetadata = newObjectMetadata != null ? newObjectMetadata.build() : null;
        }

        public final Collection<S3Tag.Builder> getNewObjectTagging() {
            return this.newObjectTagging != null ? (Collection)this.newObjectTagging.stream().map(S3Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder newObjectTagging(Collection<S3Tag> newObjectTagging) {
            this.newObjectTagging = S3TagSetCopier.copy(newObjectTagging);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newObjectTagging(S3Tag ... newObjectTagging) {
            this.newObjectTagging(Arrays.asList(newObjectTagging));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newObjectTagging(Consumer<S3Tag.Builder> ... newObjectTagging) {
            this.newObjectTagging(Stream.of(newObjectTagging).map(c -> (S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNewObjectTagging(Collection<S3Tag.BuilderImpl> newObjectTagging) {
            this.newObjectTagging = S3TagSetCopier.copyFromBuilder(newObjectTagging);
        }

        public final String getRedirectLocation() {
            return this.redirectLocation;
        }

        @Override
        public final Builder redirectLocation(String redirectLocation) {
            this.redirectLocation = redirectLocation;
            return this;
        }

        public final void setRedirectLocation(String redirectLocation) {
            this.redirectLocation = redirectLocation;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(S3StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Instant getUnModifiedSinceConstraint() {
            return this.unModifiedSinceConstraint;
        }

        @Override
        public final Builder unModifiedSinceConstraint(Instant unModifiedSinceConstraint) {
            this.unModifiedSinceConstraint = unModifiedSinceConstraint;
            return this;
        }

        public final void setUnModifiedSinceConstraint(Instant unModifiedSinceConstraint) {
            this.unModifiedSinceConstraint = unModifiedSinceConstraint;
        }

        public final String getSseAwsKmsKeyId() {
            return this.sseAwsKmsKeyId;
        }

        @Override
        public final Builder sseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
            return this;
        }

        public final void setSseAwsKmsKeyId(String sseAwsKmsKeyId) {
            this.sseAwsKmsKeyId = sseAwsKmsKeyId;
        }

        public final String getTargetKeyPrefix() {
            return this.targetKeyPrefix;
        }

        @Override
        public final Builder targetKeyPrefix(String targetKeyPrefix) {
            this.targetKeyPrefix = targetKeyPrefix;
            return this;
        }

        public final void setTargetKeyPrefix(String targetKeyPrefix) {
            this.targetKeyPrefix = targetKeyPrefix;
        }

        public final String getObjectLockLegalHoldStatus() {
            return this.objectLockLegalHoldStatus;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
            return this;
        }

        @Override
        public final Builder objectLockLegalHoldStatus(S3ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus(objectLockLegalHoldStatus == null ? null : objectLockLegalHoldStatus.toString());
            return this;
        }

        public final void setObjectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = objectLockLegalHoldStatus;
        }

        public final String getObjectLockMode() {
            return this.objectLockMode;
        }

        @Override
        public final Builder objectLockMode(String objectLockMode) {
            this.objectLockMode = objectLockMode;
            return this;
        }

        @Override
        public final Builder objectLockMode(S3ObjectLockMode objectLockMode) {
            this.objectLockMode(objectLockMode == null ? null : objectLockMode.toString());
            return this;
        }

        public final void setObjectLockMode(String objectLockMode) {
            this.objectLockMode = objectLockMode;
        }

        public final Instant getObjectLockRetainUntilDate() {
            return this.objectLockRetainUntilDate;
        }

        @Override
        public final Builder objectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
            return this;
        }

        public final void setObjectLockRetainUntilDate(Instant objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = objectLockRetainUntilDate;
        }

        public S3CopyObjectOperation build() {
            return new S3CopyObjectOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3CopyObjectOperation> {
        public Builder targetResource(String var1);

        public Builder cannedAccessControlList(String var1);

        public Builder cannedAccessControlList(S3CannedAccessControlList var1);

        public Builder accessControlGrants(Collection<S3Grant> var1);

        public Builder accessControlGrants(S3Grant ... var1);

        public Builder accessControlGrants(Consumer<S3Grant.Builder> ... var1);

        public Builder metadataDirective(String var1);

        public Builder metadataDirective(S3MetadataDirective var1);

        public Builder modifiedSinceConstraint(Instant var1);

        public Builder newObjectMetadata(S3ObjectMetadata var1);

        default public Builder newObjectMetadata(Consumer<S3ObjectMetadata.Builder> newObjectMetadata) {
            return this.newObjectMetadata((S3ObjectMetadata)((S3ObjectMetadata.Builder)S3ObjectMetadata.builder().applyMutation(newObjectMetadata)).build());
        }

        public Builder newObjectTagging(Collection<S3Tag> var1);

        public Builder newObjectTagging(S3Tag ... var1);

        public Builder newObjectTagging(Consumer<S3Tag.Builder> ... var1);

        public Builder redirectLocation(String var1);

        public Builder requesterPays(Boolean var1);

        public Builder storageClass(String var1);

        public Builder storageClass(S3StorageClass var1);

        public Builder unModifiedSinceConstraint(Instant var1);

        public Builder sseAwsKmsKeyId(String var1);

        public Builder targetKeyPrefix(String var1);

        public Builder objectLockLegalHoldStatus(String var1);

        public Builder objectLockLegalHoldStatus(S3ObjectLockLegalHoldStatus var1);

        public Builder objectLockMode(String var1);

        public Builder objectLockMode(S3ObjectLockMode var1);

        public Builder objectLockRetainUntilDate(Instant var1);
    }
}

