/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListJobsResponse.Builder, ListJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<JobListDescriptor>> JOBS_FIELD = SdkField
            .<List<JobListDescriptor>> builder(MarshallingType.LIST)
            .getter(getter(ListJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs")
                    .unmarshallLocationName("Jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobListDescriptor> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobListDescriptor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, JOBS_FIELD));

    private final String nextToken;

    private final List<JobListDescriptor> jobs;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.jobs = builder.jobs;
    }

    /**
     * <p>
     * If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value
     * into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this
     *         value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of current jobs and jobs that have ended within the last 30 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of current jobs and jobs that have ended within the last 30 days.
     */
    public List<JobListDescriptor> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(jobs(), other.jobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListJobsResponse").add("NextToken", nextToken()).add("Jobs", jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsResponse> {
        /**
         * <p>
         * If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this
         * value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass
         *        this value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of current jobs and jobs that have ended within the last 30 days.
         * </p>
         * 
         * @param jobs
         *        The list of current jobs and jobs that have ended within the last 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<JobListDescriptor> jobs);

        /**
         * <p>
         * The list of current jobs and jobs that have ended within the last 30 days.
         * </p>
         * 
         * @param jobs
         *        The list of current jobs and jobs that have ended within the last 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(JobListDescriptor... jobs);

        /**
         * <p>
         * The list of current jobs and jobs that have ended within the last 30 days.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobListDescriptor>.Builder} avoiding the
         * need to create one manually via {@link List<JobListDescriptor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobListDescriptor>.Builder#build()} is called immediately
         * and its result is passed to {@link #jobs(List<JobListDescriptor>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<JobListDescriptor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<JobListDescriptor>)
         */
        Builder jobs(Consumer<JobListDescriptor.Builder>... jobs);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<JobListDescriptor> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            jobs(model.jobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<JobListDescriptor.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(JobListDescriptor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<JobListDescriptor> jobs) {
            this.jobs = JobListDescriptorListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobListDescriptor... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobListDescriptor.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> JobListDescriptor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<JobListDescriptor.BuilderImpl> jobs) {
            this.jobs = JobListDescriptorListCopier.copyFromBuilder(jobs);
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
