/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.Initiator;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultipartUpload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultipartUpload> {
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MultipartUpload.getter(MultipartUpload::uploadId)).setter(MultipartUpload.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadId").unmarshallLocationName("UploadId").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MultipartUpload.getter(MultipartUpload::key)).setter(MultipartUpload.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("Key").build()}).build();
    private static final SdkField<Instant> INITIATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MultipartUpload.getter(MultipartUpload::initiated)).setter(MultipartUpload.setter(Builder::initiated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiated").unmarshallLocationName("Initiated").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MultipartUpload.getter(MultipartUpload::storageClassAsString)).setter(MultipartUpload.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").unmarshallLocationName("StorageClass").build()}).build();
    private static final SdkField<Owner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MultipartUpload.getter(MultipartUpload::owner)).setter(MultipartUpload.setter(Builder::owner)).constructor(Owner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build();
    private static final SdkField<Initiator> INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MultipartUpload.getter(MultipartUpload::initiator)).setter(MultipartUpload.setter(Builder::initiator)).constructor(Initiator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiator").unmarshallLocationName("Initiator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_ID_FIELD, KEY_FIELD, INITIATED_FIELD, STORAGE_CLASS_FIELD, OWNER_FIELD, INITIATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String uploadId;
    private final String key;
    private final Instant initiated;
    private final String storageClass;
    private final Owner owner;
    private final Initiator initiator;

    private MultipartUpload(BuilderImpl builder) {
        this.uploadId = builder.uploadId;
        this.key = builder.key;
        this.initiated = builder.initiated;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
        this.initiator = builder.initiator;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String key() {
        return this.key;
    }

    public Instant initiated() {
        return this.initiated;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public Owner owner() {
        return this.owner;
    }

    public Initiator initiator() {
        return this.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiated());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload other = (MultipartUpload)obj;
        return Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.initiated(), other.initiated()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.initiator(), other.initiator());
    }

    public String toString() {
        return ToString.builder((String)"MultipartUpload").add("UploadId", (Object)this.uploadId()).add("Key", (Object)this.key()).add("Initiated", (Object)this.initiated()).add("StorageClass", (Object)this.storageClassAsString()).add("Owner", (Object)this.owner()).add("Initiator", (Object)this.initiator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Initiated": {
                return Optional.ofNullable(clazz.cast(this.initiated()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultipartUpload, T> g) {
        return obj -> g.apply((MultipartUpload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uploadId;
        private String key;
        private Instant initiated;
        private String storageClass;
        private Owner owner;
        private Initiator initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipartUpload model) {
            this.uploadId(model.uploadId);
            this.key(model.key);
            this.initiated(model.initiated);
            this.storageClass(model.storageClass);
            this.owner(model.owner);
            this.initiator(model.initiator);
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Instant getInitiated() {
            return this.initiated;
        }

        @Override
        public final Builder initiated(Instant initiated) {
            this.initiated = initiated;
            return this;
        }

        public final void setInitiated(Instant initiated) {
            this.initiated = initiated;
        }

        public final String getStorageClassAsString() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Initiator.Builder getInitiator() {
            return this.initiator != null ? this.initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public MultipartUpload build() {
            return new MultipartUpload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultipartUpload> {
        public Builder uploadId(String var1);

        public Builder key(String var1);

        public Builder initiated(Instant var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().applyMutation(owner)).build());
        }

        public Builder initiator(Initiator var1);

        default public Builder initiator(Consumer<Initiator.Builder> initiator) {
            return this.initiator((Initiator)((Initiator.Builder)Initiator.builder().applyMutation(initiator)).build());
        }
    }
}

