/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ObjectVersion;

public class ListObjectVersionsPublisher
implements SdkPublisher<ListObjectVersionsResponse> {
    private final S3AsyncClient client;
    private final ListObjectVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectVersionsPublisher(S3AsyncClient client, ListObjectVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectVersionsPublisher(S3AsyncClient client, ListObjectVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ObjectVersion> versions() {
        return this.flatMapIterable(response -> response.versions());
    }

    public final SdkPublisher<DeleteMarkerEntry> deleteMarkers() {
        return this.flatMapIterable(response -> response.deleteMarkers());
    }

    public final SdkPublisher<CommonPrefix> commonPrefixes() {
        return this.flatMapIterable(response -> response.commonPrefixes());
    }

    private class ListObjectVersionsResponseFetcher
    implements AsyncPageFetcher<ListObjectVersionsResponse> {
        private ListObjectVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectVersionsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListObjectVersionsResponse> nextPage(ListObjectVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectVersionsPublisher.this.client.listObjectVersions(ListObjectVersionsPublisher.this.firstRequest);
            }
            return ListObjectVersionsPublisher.this.client.listObjectVersions((ListObjectVersionsRequest)((Object)ListObjectVersionsPublisher.this.firstRequest.toBuilder().keyMarker(previousPage.nextKeyMarker()).versionIdMarker(previousPage.nextVersionIdMarker()).build()));
        }
    }
}

