/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.EncryptionType;
import software.amazon.awssdk.services.s3.model.EncryptionTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockedEncryptionTypes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockedEncryptionTypes> {
    private static final SdkField<List<String>> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EncryptionType").getter(BlockedEncryptionTypes.getter(BlockedEncryptionTypes::encryptionTypeAsStrings)).setter(BlockedEncryptionTypes.setter(Builder::encryptionTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").unmarshallLocationName("EncryptionType").build(), ListTrait.builder().memberLocationName("EncryptionType").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").unmarshallLocationName("EncryptionType").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BlockedEncryptionTypes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> encryptionType;

    private BlockedEncryptionTypes(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
    }

    public final List<EncryptionType> encryptionType() {
        return EncryptionTypeListCopier.copyStringToEnum(this.encryptionType);
    }

    public final boolean hasEncryptionType() {
        return this.encryptionType != null && !(this.encryptionType instanceof SdkAutoConstructList);
    }

    public final List<String> encryptionTypeAsStrings() {
        return this.encryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionType() ? this.encryptionTypeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockedEncryptionTypes)) {
            return false;
        }
        BlockedEncryptionTypes other = (BlockedEncryptionTypes)obj;
        return this.hasEncryptionType() == other.hasEncryptionType() && Objects.equals(this.encryptionTypeAsStrings(), other.encryptionTypeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BlockedEncryptionTypes").add("EncryptionType", this.hasEncryptionType() ? this.encryptionTypeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockedEncryptionTypes, T> g) {
        return obj -> g.apply((BlockedEncryptionTypes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> encryptionType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlockedEncryptionTypes model) {
            this.encryptionTypeWithStrings(model.encryptionType);
        }

        public final Collection<String> getEncryptionType() {
            if (this.encryptionType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.encryptionType;
        }

        public final void setEncryptionType(Collection<String> encryptionType) {
            this.encryptionType = EncryptionTypeListCopier.copy(encryptionType);
        }

        @Override
        public final Builder encryptionTypeWithStrings(Collection<String> encryptionType) {
            this.encryptionType = EncryptionTypeListCopier.copy(encryptionType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionTypeWithStrings(String ... encryptionType) {
            this.encryptionTypeWithStrings(Arrays.asList(encryptionType));
            return this;
        }

        @Override
        public final Builder encryptionType(Collection<EncryptionType> encryptionType) {
            this.encryptionType = EncryptionTypeListCopier.copyEnumToString(encryptionType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionType(EncryptionType ... encryptionType) {
            this.encryptionType(Arrays.asList(encryptionType));
            return this;
        }

        public BlockedEncryptionTypes build() {
            return new BlockedEncryptionTypes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockedEncryptionTypes> {
        public Builder encryptionTypeWithStrings(Collection<String> var1);

        public Builder encryptionTypeWithStrings(String ... var1);

        public Builder encryptionType(Collection<EncryptionType> var1);

        public Builder encryptionType(EncryptionType ... var1);
    }
}

