/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionType {
    NONE("NONE"),
    SSE_C("SSE-C"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionType> VALUE_MAP;
    private final String value;

    private EncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionType> knownValues() {
        EnumSet<EncryptionType> knownValues = EnumSet.allOf(EncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionType.class, EncryptionType::toString);
    }
}

