/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@SdkInternalApi
public class EnableTrailingChecksumInterceptor
implements ExecutionInterceptor {
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetObjectRequest && this.checksumValidationEnabled(executionAttributes)) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("x-amz-te", "append-md5").build();
        }
        return context.httpRequest();
    }

    public SdkResponse modifyResponse(Context.ModifyResponse context, ExecutionAttributes executionAttributes) {
        SdkResponse response = context.response();
        SdkHttpResponse httpResponse = context.httpResponse();
        if (response instanceof GetObjectResponse && httpResponse.firstMatchingHeader("x-amz-transfer-encoding").isPresent()) {
            GetObjectResponse getResponse = (GetObjectResponse)response;
            return (SdkResponse)getResponse.toBuilder().contentLength(getResponse.contentLength() - 16L).build();
        }
        return response;
    }

    private boolean checksumValidationEnabled(ExecutionAttributes executionAttributes) {
        S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        return serviceConfiguration == null || serviceConfiguration.checksumValidationEnabled();
    }
}

