/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class S3CrtDataPublisher
implements SdkPublisher<ByteBuffer> {
    private static final Logger log = Logger.loggerFor(S3CrtDataPublisher.class);
    private static final Event COMPLETE = new CompleteEvent();
    private static final Event CANCEL = new CancelEvent();
    private final AtomicBoolean isDelivering = new AtomicBoolean(false);
    private final Queue<Event> buffer = new ConcurrentLinkedQueue<Event>();
    private final AtomicLong outstandingDemand = new AtomicLong(0L);
    private final AtomicReference<Subscriber<? super ByteBuffer>> subscriberRef = new AtomicReference<Object>(null);
    private volatile boolean isDone;

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        if (!this.subscriberRef.compareAndSet(null, subscriber)) {
            log.error(() -> "DataPublisher can only be subscribed to once.");
            throw new IllegalStateException("DataPublisher may only be subscribed to once");
        }
        subscriber.onSubscribe((Subscription)new DataSubscription());
        this.notifyErrorIfNeeded(subscriber);
    }

    public void notifyStreamingFinished() {
        if (this.isDone) {
            return;
        }
        this.buffer.add(COMPLETE);
        this.flushBuffer();
    }

    public void notifyError(Exception exception) {
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.buffer.clear();
        this.buffer.add(new ErrorEvent(exception));
        this.flushBuffer();
    }

    public void deliverData(ByteBuffer byteBuffer) {
        if (this.isDone) {
            return;
        }
        this.buffer.add(new DataEvent(byteBuffer));
        this.flushBuffer();
    }

    private void notifyErrorIfNeeded(Subscriber<? super ByteBuffer> subscriber) {
        Event event = this.buffer.peek();
        if (event != null && event.type() == EventType.ERROR) {
            this.isDone = true;
            subscriber.onError(((ErrorEvent)event).error());
        }
    }

    private boolean isTerminalEvent(Event event) {
        return event.type() == EventType.ERROR || event.type() == EventType.COMPLETE || event.type() == EventType.CANCEL;
    }

    private void handleTerminalEvent(Event event) {
        switch (event.type()) {
            case COMPLETE: {
                this.isDone = true;
                this.subscriberRef.get().onComplete();
                break;
            }
            case ERROR: {
                ErrorEvent errorEvent = (ErrorEvent)event;
                this.subscriberRef.get().onError(errorEvent.error());
                break;
            }
            case CANCEL: {
                this.subscriberRef.set(null);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)event.type()));
            }
        }
    }

    private void flushBuffer() {
        if (this.buffer.isEmpty()) {
            return;
        }
        if (this.subscriberRef.get() != null && this.isDelivering.compareAndSet(false, true)) {
            Event firstEvent = this.buffer.peek();
            if (firstEvent != null && this.isTerminalEvent(firstEvent)) {
                Event terminalEvent = this.buffer.poll();
                this.handleTerminalEvent(terminalEvent);
                this.isDelivering.set(false);
                return;
            }
            while (!this.buffer.isEmpty() && this.outstandingDemand.get() > 0L) {
                log.trace(() -> "Publishing data, buffer size: " + this.buffer.size() + ", demand: " + this.outstandingDemand.get());
                Event event = this.buffer.poll();
                if (event == null || this.subscriberRef.get() == null) break;
                if (this.isTerminalEvent(event)) {
                    this.handleTerminalEvent(event);
                    this.isDelivering.set(false);
                    return;
                }
                DataEvent dataEvent = (DataEvent)event;
                this.outstandingDemand.decrementAndGet();
                this.subscriberRef.get().onNext((Object)dataEvent.data());
            }
            this.isDelivering.set(false);
        }
    }

    private static class ErrorEvent
    implements Event {
        private final Throwable error;

        ErrorEvent(Throwable error) {
            this.error = error;
        }

        @Override
        public EventType type() {
            return EventType.ERROR;
        }

        public final Throwable error() {
            return this.error;
        }
    }

    private static final class CancelEvent
    implements Event {
        private CancelEvent() {
        }

        @Override
        public EventType type() {
            return EventType.CANCEL;
        }
    }

    private static final class CompleteEvent
    implements Event {
        private CompleteEvent() {
        }

        @Override
        public EventType type() {
            return EventType.COMPLETE;
        }
    }

    private static final class DataEvent
    implements Event {
        private final ByteBuffer data;

        DataEvent(ByteBuffer data) {
            this.data = data;
        }

        @Override
        public EventType type() {
            return EventType.DATA;
        }

        public ByteBuffer data() {
            return this.data;
        }
    }

    private static interface Event {
        public EventType type();
    }

    private static enum EventType {
        DATA,
        COMPLETE,
        ERROR,
        CANCEL;

    }

    private final class DataSubscription
    implements Subscription {
        private DataSubscription() {
        }

        public void request(long n) {
            if (S3CrtDataPublisher.this.isDone) {
                return;
            }
            if (n <= 0L) {
                ((Subscriber)S3CrtDataPublisher.this.subscriberRef.get()).onError((Throwable)new IllegalArgumentException("Request is for <= 0 elements: " + n));
                return;
            }
            this.addDemand(n);
            log.trace(() -> "Received demand: " + n + ". Total demands: " + S3CrtDataPublisher.this.outstandingDemand.get());
            S3CrtDataPublisher.this.flushBuffer();
        }

        public void cancel() {
            if (S3CrtDataPublisher.this.isDone) {
                return;
            }
            log.debug(() -> "The subscription is cancelled");
            S3CrtDataPublisher.this.isDone = true;
            S3CrtDataPublisher.this.buffer.clear();
            S3CrtDataPublisher.this.buffer.add(CANCEL);
            S3CrtDataPublisher.this.flushBuffer();
        }

        private void addDemand(long n) {
            S3CrtDataPublisher.this.outstandingDemand.getAndUpdate(initialDemand -> {
                if (Long.MAX_VALUE - initialDemand < n) {
                    return Long.MAX_VALUE;
                }
                return initialDemand + n;
            });
        }
    }
}

