/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ObjectOwnership {
    BUCKET_OWNER_PREFERRED("BucketOwnerPreferred"),
    OBJECT_WRITER("ObjectWriter"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ObjectOwnership(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectOwnership fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ObjectOwnership.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectOwnership> knownValues() {
        return Stream.of(ObjectOwnership.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

