/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rum.model.MetricDestination;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRumMetricsDestinationRequest
extends RumRequest
implements ToCopyableBuilder<Builder, PutRumMetricsDestinationRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppMonitorName").getter(PutRumMetricsDestinationRequest.getter(PutRumMetricsDestinationRequest::appMonitorName)).setter(PutRumMetricsDestinationRequest.setter(Builder::appMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(PutRumMetricsDestinationRequest.getter(PutRumMetricsDestinationRequest::destinationAsString)).setter(PutRumMetricsDestinationRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(PutRumMetricsDestinationRequest.getter(PutRumMetricsDestinationRequest::destinationArn)).setter(PutRumMetricsDestinationRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(PutRumMetricsDestinationRequest.getter(PutRumMetricsDestinationRequest::iamRoleArn)).setter(PutRumMetricsDestinationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD, DESTINATION_FIELD, DESTINATION_ARN_FIELD, IAM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRumMetricsDestinationRequest.memberNameToFieldInitializer();
    private final String appMonitorName;
    private final String destination;
    private final String destinationArn;
    private final String iamRoleArn;

    private PutRumMetricsDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.iamRoleArn = builder.iamRoleArn;
    }

    public final String appMonitorName() {
        return this.appMonitorName;
    }

    public final MetricDestination destination() {
        return MetricDestination.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRumMetricsDestinationRequest)) {
            return false;
        }
        PutRumMetricsDestinationRequest other = (PutRumMetricsDestinationRequest)((Object)obj);
        return Objects.equals(this.appMonitorName(), other.appMonitorName()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutRumMetricsDestinationRequest").add("AppMonitorName", (Object)this.appMonitorName()).add("Destination", (Object)this.destinationAsString()).add("DestinationArn", (Object)this.destinationArn()).add("IamRoleArn", (Object)this.iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.appMonitorName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRumMetricsDestinationRequest, T> g) {
        return obj -> g.apply((PutRumMetricsDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String appMonitorName;
        private String destination;
        private String destinationArn;
        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRumMetricsDestinationRequest model) {
            super(model);
            this.appMonitorName(model.appMonitorName);
            this.destination(model.destination);
            this.destinationArn(model.destinationArn);
            this.iamRoleArn(model.iamRoleArn);
        }

        public final String getAppMonitorName() {
            return this.appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRumMetricsDestinationRequest build() {
            return new PutRumMetricsDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRumMetricsDestinationRequest> {
        public Builder appMonitorName(String var1);

        public Builder destination(String var1);

        public Builder destination(MetricDestination var1);

        public Builder destinationArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

