/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rum.model.DimensionKeysMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDefinitionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDefinitionRequest> {
    private static final SdkField<Map<String, String>> DIMENSION_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DimensionKeys").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::dimensionKeys)).setter(MetricDefinitionRequest.setter(Builder::dimensionKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventPattern").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::eventPattern)).setter(MetricDefinitionRequest.setter(Builder::eventPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventPattern").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::name)).setter(MetricDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::namespace)).setter(MetricDefinitionRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> UNIT_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnitLabel").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::unitLabel)).setter(MetricDefinitionRequest.setter(Builder::unitLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitLabel").build()}).build();
    private static final SdkField<String> VALUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueKey").getter(MetricDefinitionRequest.getter(MetricDefinitionRequest::valueKey)).setter(MetricDefinitionRequest.setter(Builder::valueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_KEYS_FIELD, EVENT_PATTERN_FIELD, NAME_FIELD, NAMESPACE_FIELD, UNIT_LABEL_FIELD, VALUE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricDefinitionRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> dimensionKeys;
    private final String eventPattern;
    private final String name;
    private final String namespace;
    private final String unitLabel;
    private final String valueKey;

    private MetricDefinitionRequest(BuilderImpl builder) {
        this.dimensionKeys = builder.dimensionKeys;
        this.eventPattern = builder.eventPattern;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.unitLabel = builder.unitLabel;
        this.valueKey = builder.valueKey;
    }

    public final boolean hasDimensionKeys() {
        return this.dimensionKeys != null && !(this.dimensionKeys instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dimensionKeys() {
        return this.dimensionKeys;
    }

    public final String eventPattern() {
        return this.eventPattern;
    }

    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String unitLabel() {
        return this.unitLabel;
    }

    public final String valueKey() {
        return this.valueKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionKeys() ? this.dimensionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDefinitionRequest)) {
            return false;
        }
        MetricDefinitionRequest other = (MetricDefinitionRequest)obj;
        return this.hasDimensionKeys() == other.hasDimensionKeys() && Objects.equals(this.dimensionKeys(), other.dimensionKeys()) && Objects.equals(this.eventPattern(), other.eventPattern()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.unitLabel(), other.unitLabel()) && Objects.equals(this.valueKey(), other.valueKey());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDefinitionRequest").add("DimensionKeys", this.hasDimensionKeys() ? this.dimensionKeys() : null).add("EventPattern", (Object)this.eventPattern()).add("Name", (Object)this.name()).add("Namespace", (Object)this.namespace()).add("UnitLabel", (Object)this.unitLabel()).add("ValueKey", (Object)this.valueKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionKeys": {
                return Optional.ofNullable(clazz.cast(this.dimensionKeys()));
            }
            case "EventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "UnitLabel": {
                return Optional.ofNullable(clazz.cast(this.unitLabel()));
            }
            case "ValueKey": {
                return Optional.ofNullable(clazz.cast(this.valueKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DimensionKeys", DIMENSION_KEYS_FIELD);
        map.put("EventPattern", EVENT_PATTERN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("UnitLabel", UNIT_LABEL_FIELD);
        map.put("ValueKey", VALUE_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDefinitionRequest, T> g) {
        return obj -> g.apply((MetricDefinitionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> dimensionKeys = DefaultSdkAutoConstructMap.getInstance();
        private String eventPattern;
        private String name;
        private String namespace;
        private String unitLabel;
        private String valueKey;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDefinitionRequest model) {
            this.dimensionKeys(model.dimensionKeys);
            this.eventPattern(model.eventPattern);
            this.name(model.name);
            this.namespace(model.namespace);
            this.unitLabel(model.unitLabel);
            this.valueKey(model.valueKey);
        }

        public final Map<String, String> getDimensionKeys() {
            if (this.dimensionKeys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dimensionKeys;
        }

        public final void setDimensionKeys(Map<String, String> dimensionKeys) {
            this.dimensionKeys = DimensionKeysMapCopier.copy(dimensionKeys);
        }

        @Override
        public final Builder dimensionKeys(Map<String, String> dimensionKeys) {
            this.dimensionKeys = DimensionKeysMapCopier.copy(dimensionKeys);
            return this;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getUnitLabel() {
            return this.unitLabel;
        }

        public final void setUnitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
        }

        @Override
        public final Builder unitLabel(String unitLabel) {
            this.unitLabel = unitLabel;
            return this;
        }

        public final String getValueKey() {
            return this.valueKey;
        }

        public final void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        @Override
        public final Builder valueKey(String valueKey) {
            this.valueKey = valueKey;
            return this;
        }

        public MetricDefinitionRequest build() {
            return new MetricDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDefinitionRequest> {
        public Builder dimensionKeys(Map<String, String> var1);

        public Builder eventPattern(String var1);

        public Builder name(String var1);

        public Builder namespace(String var1);

        public Builder unitLabel(String var1);

        public Builder valueKey(String var1);
    }
}

