/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.internal.UserAgentUtils;
import software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest;
import software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse;
import software.amazon.awssdk.services.rum.model.MetricDefinition;

public class BatchGetRumMetricDefinitionsPublisher
implements SdkPublisher<BatchGetRumMetricDefinitionsResponse> {
    private final RumAsyncClient client;
    private final BatchGetRumMetricDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetRumMetricDefinitionsPublisher(RumAsyncClient client, BatchGetRumMetricDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetRumMetricDefinitionsPublisher(RumAsyncClient client, BatchGetRumMetricDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetRumMetricDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetRumMetricDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricDefinition> metricDefinitions() {
        Function<BatchGetRumMetricDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDefinitions() != null) {
                return response.metricDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new BatchGetRumMetricDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class BatchGetRumMetricDefinitionsResponseFetcher
    implements AsyncPageFetcher<BatchGetRumMetricDefinitionsResponse> {
        private BatchGetRumMetricDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetRumMetricDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetRumMetricDefinitionsResponse> nextPage(BatchGetRumMetricDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return BatchGetRumMetricDefinitionsPublisher.this.client.batchGetRumMetricDefinitions(BatchGetRumMetricDefinitionsPublisher.this.firstRequest);
            }
            return BatchGetRumMetricDefinitionsPublisher.this.client.batchGetRumMetricDefinitions((BatchGetRumMetricDefinitionsRequest)((Object)BatchGetRumMetricDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

