/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.MetricDefinitionRequest;
import software.amazon.awssdk.services.rum.model.MetricDefinitionsRequestCopier;
import software.amazon.awssdk.services.rum.model.MetricDestination;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateRumMetricDefinitionsRequest
extends RumRequest
implements ToCopyableBuilder<Builder, BatchCreateRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppMonitorName").getter(BatchCreateRumMetricDefinitionsRequest.getter(BatchCreateRumMetricDefinitionsRequest::appMonitorName)).setter(BatchCreateRumMetricDefinitionsRequest.setter(Builder::appMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(BatchCreateRumMetricDefinitionsRequest.getter(BatchCreateRumMetricDefinitionsRequest::destinationAsString)).setter(BatchCreateRumMetricDefinitionsRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(BatchCreateRumMetricDefinitionsRequest.getter(BatchCreateRumMetricDefinitionsRequest::destinationArn)).setter(BatchCreateRumMetricDefinitionsRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final SdkField<List<MetricDefinitionRequest>> METRIC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitions").getter(BatchCreateRumMetricDefinitionsRequest.getter(BatchCreateRumMetricDefinitionsRequest::metricDefinitions)).setter(BatchCreateRumMetricDefinitionsRequest.setter(Builder::metricDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDefinitionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD, DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("DestinationArn", DESTINATION_ARN_FIELD);
            this.put("MetricDefinitions", METRIC_DEFINITIONS_FIELD);
        }
    });
    private final String appMonitorName;
    private final String destination;
    private final String destinationArn;
    private final List<MetricDefinitionRequest> metricDefinitions;

    private BatchCreateRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinitions = builder.metricDefinitions;
    }

    public final String appMonitorName() {
        return this.appMonitorName;
    }

    public final MetricDestination destination() {
        return MetricDestination.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final boolean hasMetricDefinitions() {
        return this.metricDefinitions != null && !(this.metricDefinitions instanceof SdkAutoConstructList);
    }

    public final List<MetricDefinitionRequest> metricDefinitions() {
        return this.metricDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitions() ? this.metricDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchCreateRumMetricDefinitionsRequest other = (BatchCreateRumMetricDefinitionsRequest)((Object)obj);
        return Objects.equals(this.appMonitorName(), other.appMonitorName()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.destinationArn(), other.destinationArn()) && this.hasMetricDefinitions() == other.hasMetricDefinitions() && Objects.equals(this.metricDefinitions(), other.metricDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateRumMetricDefinitionsRequest").add("AppMonitorName", (Object)this.appMonitorName()).add("Destination", (Object)this.destinationAsString()).add("DestinationArn", (Object)this.destinationArn()).add("MetricDefinitions", this.hasMetricDefinitions() ? this.metricDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.appMonitorName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "MetricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchCreateRumMetricDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String appMonitorName;
        private String destination;
        private String destinationArn;
        private List<MetricDefinitionRequest> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateRumMetricDefinitionsRequest model) {
            super(model);
            this.appMonitorName(model.appMonitorName);
            this.destination(model.destination);
            this.destinationArn(model.destinationArn);
            this.metricDefinitions(model.metricDefinitions);
        }

        public final String getAppMonitorName() {
            return this.appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final List<MetricDefinitionRequest.Builder> getMetricDefinitions() {
            List<MetricDefinitionRequest.Builder> result = MetricDefinitionsRequestCopier.copyToBuilder(this.metricDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDefinitions(Collection<MetricDefinitionRequest.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsRequestCopier.copyFromBuilder(metricDefinitions);
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinitionRequest> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionsRequestCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinitionRequest ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinitionRequest.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinitionRequest)((MetricDefinitionRequest.Builder)MetricDefinitionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateRumMetricDefinitionsRequest build() {
            return new BatchCreateRumMetricDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateRumMetricDefinitionsRequest> {
        public Builder appMonitorName(String var1);

        public Builder destination(String var1);

        public Builder destination(MetricDestination var1);

        public Builder destinationArn(String var1);

        public Builder metricDefinitions(Collection<MetricDefinitionRequest> var1);

        public Builder metricDefinitions(MetricDefinitionRequest ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinitionRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

