/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rum.model.MetricDefinitionIdsCopier;
import software.amazon.awssdk.services.rum.model.MetricDestination;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteRumMetricDefinitionsRequest
extends RumRequest
implements ToCopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppMonitorName").getter(BatchDeleteRumMetricDefinitionsRequest.getter(BatchDeleteRumMetricDefinitionsRequest::appMonitorName)).setter(BatchDeleteRumMetricDefinitionsRequest.setter(Builder::appMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(BatchDeleteRumMetricDefinitionsRequest.getter(BatchDeleteRumMetricDefinitionsRequest::destinationAsString)).setter(BatchDeleteRumMetricDefinitionsRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destination").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(BatchDeleteRumMetricDefinitionsRequest.getter(BatchDeleteRumMetricDefinitionsRequest::destinationArn)).setter(BatchDeleteRumMetricDefinitionsRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationArn").build()}).build();
    private static final SdkField<List<String>> METRIC_DEFINITION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitionIds").getter(BatchDeleteRumMetricDefinitionsRequest.getter(BatchDeleteRumMetricDefinitionsRequest::metricDefinitionIds)).setter(BatchDeleteRumMetricDefinitionsRequest.setter(Builder::metricDefinitionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metricDefinitionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD, DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITION_IDS_FIELD));
    private final String appMonitorName;
    private final String destination;
    private final String destinationArn;
    private final List<String> metricDefinitionIds;

    private BatchDeleteRumMetricDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinitionIds = builder.metricDefinitionIds;
    }

    public final String appMonitorName() {
        return this.appMonitorName;
    }

    public final MetricDestination destination() {
        return MetricDestination.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final boolean hasMetricDefinitionIds() {
        return this.metricDefinitionIds != null && !(this.metricDefinitionIds instanceof SdkAutoConstructList);
    }

    public final List<String> metricDefinitionIds() {
        return this.metricDefinitionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDefinitionIds() ? this.metricDefinitionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRumMetricDefinitionsRequest)) {
            return false;
        }
        BatchDeleteRumMetricDefinitionsRequest other = (BatchDeleteRumMetricDefinitionsRequest)((Object)obj);
        return Objects.equals(this.appMonitorName(), other.appMonitorName()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.destinationArn(), other.destinationArn()) && this.hasMetricDefinitionIds() == other.hasMetricDefinitionIds() && Objects.equals(this.metricDefinitionIds(), other.metricDefinitionIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteRumMetricDefinitionsRequest").add("AppMonitorName", (Object)this.appMonitorName()).add("Destination", (Object)this.destinationAsString()).add("DestinationArn", (Object)this.destinationArn()).add("MetricDefinitionIds", this.hasMetricDefinitionIds() ? this.metricDefinitionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.appMonitorName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "MetricDefinitionIds": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRumMetricDefinitionsRequest, T> g) {
        return obj -> g.apply((BatchDeleteRumMetricDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String appMonitorName;
        private String destination;
        private String destinationArn;
        private List<String> metricDefinitionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRumMetricDefinitionsRequest model) {
            super(model);
            this.appMonitorName(model.appMonitorName);
            this.destination(model.destination);
            this.destinationArn(model.destinationArn);
            this.metricDefinitionIds(model.metricDefinitionIds);
        }

        public final String getAppMonitorName() {
            return this.appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final Collection<String> getMetricDefinitionIds() {
            if (this.metricDefinitionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricDefinitionIds;
        }

        public final void setMetricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
        }

        @Override
        public final Builder metricDefinitionIds(Collection<String> metricDefinitionIds) {
            this.metricDefinitionIds = MetricDefinitionIdsCopier.copy(metricDefinitionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitionIds(String ... metricDefinitionIds) {
            this.metricDefinitionIds(Arrays.asList(metricDefinitionIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteRumMetricDefinitionsRequest build() {
            return new BatchDeleteRumMetricDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteRumMetricDefinitionsRequest> {
        public Builder appMonitorName(String var1);

        public Builder destination(String var1);

        public Builder destination(MetricDestination var1);

        public Builder destinationArn(String var1);

        public Builder metricDefinitionIds(Collection<String> var1);

        public Builder metricDefinitionIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

