/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rum.DefaultRumBaseClientBuilder;
import software.amazon.awssdk.services.rum.DefaultRumClient;
import software.amazon.awssdk.services.rum.RumClient;
import software.amazon.awssdk.services.rum.RumClientBuilder;
import software.amazon.awssdk.services.rum.RumServiceClientConfiguration;
import software.amazon.awssdk.services.rum.endpoints.RumEndpointProvider;

@SdkInternalApi
final class DefaultRumClientBuilder
extends DefaultRumBaseClientBuilder<RumClientBuilder, RumClient>
implements RumClientBuilder {
    DefaultRumClientBuilder() {
    }

    @Override
    public DefaultRumClientBuilder endpointProvider(RumEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RumClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRumClientBuilder.validateClientOptions(clientConfiguration);
        RumServiceClientConfiguration serviceClientConfiguration = RumServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultRumClient(serviceClientConfiguration, clientConfiguration);
    }
}

