/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumClient;
import software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest;
import software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse;
import software.amazon.awssdk.services.rum.model.MetricDestinationSummary;

public class ListRumMetricsDestinationsIterable
implements SdkIterable<ListRumMetricsDestinationsResponse> {
    private final RumClient client;
    private final ListRumMetricsDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRumMetricsDestinationsIterable(RumClient client, ListRumMetricsDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRumMetricsDestinationsResponseFetcher();
    }

    public Iterator<ListRumMetricsDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricDestinationSummary> destinations() {
        Function<ListRumMetricsDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRumMetricsDestinationsResponseFetcher
    implements SyncPageFetcher<ListRumMetricsDestinationsResponse> {
        private ListRumMetricsDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRumMetricsDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRumMetricsDestinationsResponse nextPage(ListRumMetricsDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListRumMetricsDestinationsIterable.this.client.listRumMetricsDestinations(ListRumMetricsDestinationsIterable.this.firstRequest);
            }
            return ListRumMetricsDestinationsIterable.this.client.listRumMetricsDestinations((ListRumMetricsDestinationsRequest)((Object)ListRumMetricsDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

