/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rtbfabric.RtbFabricClient;
import software.amazon.awssdk.services.rtbfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksResponse;
import software.amazon.awssdk.services.rtbfabric.model.ListLinksResponseStructure;

public class ListLinksIterable
implements SdkIterable<ListLinksResponse> {
    private final RtbFabricClient client;
    private final ListLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLinksIterable(RtbFabricClient client, ListLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLinksResponseFetcher();
    }

    public Iterator<ListLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListLinksResponseStructure> links() {
        Function<ListLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.links() != null) {
                return response.links().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLinksResponseFetcher
    implements SyncPageFetcher<ListLinksResponse> {
        private ListLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLinksResponse nextPage(ListLinksResponse previousPage) {
            if (previousPage == null) {
                return ListLinksIterable.this.client.listLinks(ListLinksIterable.this.firstRequest);
            }
            return ListLinksIterable.this.client.listLinks((ListLinksRequest)((Object)ListLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

