/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.LinkAttributes;
import software.amazon.awssdk.services.rtbfabric.model.LinkDirection;
import software.amazon.awssdk.services.rtbfabric.model.LinkStatus;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfigurationListCopier;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptLinkResponse
extends RtbFabricResponse
implements ToCopyableBuilder<Builder, AcceptLinkResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(AcceptLinkResponse.getter(AcceptLinkResponse::gatewayId)).setter(AcceptLinkResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> PEER_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("peerGatewayId").getter(AcceptLinkResponse.getter(AcceptLinkResponse::peerGatewayId)).setter(AcceptLinkResponse.setter(Builder::peerGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerGatewayId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AcceptLinkResponse.getter(AcceptLinkResponse::statusAsString)).setter(AcceptLinkResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AcceptLinkResponse.getter(AcceptLinkResponse::createdAt)).setter(AcceptLinkResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AcceptLinkResponse.getter(AcceptLinkResponse::updatedAt)).setter(AcceptLinkResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("direction").getter(AcceptLinkResponse.getter(AcceptLinkResponse::directionAsString)).setter(AcceptLinkResponse.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("direction").build()}).build();
    private static final SdkField<List<ModuleConfiguration>> FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowModules").getter(AcceptLinkResponse.getter(AcceptLinkResponse::flowModules)).setter(AcceptLinkResponse.setter(Builder::flowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModuleConfiguration>> PENDING_FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pendingFlowModules").getter(AcceptLinkResponse.getter(AcceptLinkResponse::pendingFlowModules)).setter(AcceptLinkResponse.setter(Builder::pendingFlowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingFlowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributes").getter(AcceptLinkResponse.getter(AcceptLinkResponse::attributes)).setter(AcceptLinkResponse.setter(Builder::attributes)).constructor(LinkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linkId").getter(AcceptLinkResponse.getter(AcceptLinkResponse::linkId)).setter(AcceptLinkResponse.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, PEER_GATEWAY_ID_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DIRECTION_FIELD, FLOW_MODULES_FIELD, PENDING_FLOW_MODULES_FIELD, ATTRIBUTES_FIELD, LINK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AcceptLinkResponse.memberNameToFieldInitializer();
    private final String gatewayId;
    private final String peerGatewayId;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String direction;
    private final List<ModuleConfiguration> flowModules;
    private final List<ModuleConfiguration> pendingFlowModules;
    private final LinkAttributes attributes;
    private final String linkId;

    private AcceptLinkResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.peerGatewayId = builder.peerGatewayId;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.direction = builder.direction;
        this.flowModules = builder.flowModules;
        this.pendingFlowModules = builder.pendingFlowModules;
        this.attributes = builder.attributes;
        this.linkId = builder.linkId;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String peerGatewayId() {
        return this.peerGatewayId;
    }

    public final LinkStatus status() {
        return LinkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final LinkDirection direction() {
        return LinkDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final boolean hasFlowModules() {
        return this.flowModules != null && !(this.flowModules instanceof SdkAutoConstructList);
    }

    public final List<ModuleConfiguration> flowModules() {
        return this.flowModules;
    }

    public final boolean hasPendingFlowModules() {
        return this.pendingFlowModules != null && !(this.pendingFlowModules instanceof SdkAutoConstructList);
    }

    public final List<ModuleConfiguration> pendingFlowModules() {
        return this.pendingFlowModules;
    }

    public final LinkAttributes attributes() {
        return this.attributes;
    }

    public final String linkId() {
        return this.linkId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowModules() ? this.flowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingFlowModules() ? this.pendingFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptLinkResponse)) {
            return false;
        }
        AcceptLinkResponse other = (AcceptLinkResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.peerGatewayId(), other.peerGatewayId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.directionAsString(), other.directionAsString()) && this.hasFlowModules() == other.hasFlowModules() && Objects.equals(this.flowModules(), other.flowModules()) && this.hasPendingFlowModules() == other.hasPendingFlowModules() && Objects.equals(this.pendingFlowModules(), other.pendingFlowModules()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.linkId(), other.linkId());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptLinkResponse").add("GatewayId", (Object)this.gatewayId()).add("PeerGatewayId", (Object)this.peerGatewayId()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Direction", (Object)this.directionAsString()).add("FlowModules", this.hasFlowModules() ? this.flowModules() : null).add("PendingFlowModules", this.hasPendingFlowModules() ? this.pendingFlowModules() : null).add("Attributes", (Object)this.attributes()).add("LinkId", (Object)this.linkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "peerGatewayId": {
                return Optional.ofNullable(clazz.cast(this.peerGatewayId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "flowModules": {
                return Optional.ofNullable(clazz.cast(this.flowModules()));
            }
            case "pendingFlowModules": {
                return Optional.ofNullable(clazz.cast(this.pendingFlowModules()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "linkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("peerGatewayId", PEER_GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("direction", DIRECTION_FIELD);
        map.put("flowModules", FLOW_MODULES_FIELD);
        map.put("pendingFlowModules", PENDING_FLOW_MODULES_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptLinkResponse, T> g) {
        return obj -> g.apply((AcceptLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String peerGatewayId;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;
        private String direction;
        private List<ModuleConfiguration> flowModules = DefaultSdkAutoConstructList.getInstance();
        private List<ModuleConfiguration> pendingFlowModules = DefaultSdkAutoConstructList.getInstance();
        private LinkAttributes attributes;
        private String linkId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptLinkResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.peerGatewayId(model.peerGatewayId);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.direction(model.direction);
            this.flowModules(model.flowModules);
            this.pendingFlowModules(model.pendingFlowModules);
            this.attributes(model.attributes);
            this.linkId(model.linkId);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPeerGatewayId() {
            return this.peerGatewayId;
        }

        public final void setPeerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
        }

        @Override
        public final Builder peerGatewayId(String peerGatewayId) {
            this.peerGatewayId = peerGatewayId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LinkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(LinkDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final List<ModuleConfiguration.Builder> getFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.flowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowModules(Collection<ModuleConfiguration.BuilderImpl> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copyFromBuilder(flowModules);
        }

        @Override
        public final Builder flowModules(Collection<ModuleConfiguration> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copy(flowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(ModuleConfiguration ... flowModules) {
            this.flowModules(Arrays.asList(flowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(Consumer<ModuleConfiguration.Builder> ... flowModules) {
            this.flowModules(Stream.of(flowModules).map(c -> (ModuleConfiguration)((ModuleConfiguration.Builder)ModuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModuleConfiguration.Builder> getPendingFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.pendingFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingFlowModules(Collection<ModuleConfiguration.BuilderImpl> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copyFromBuilder(pendingFlowModules);
        }

        @Override
        public final Builder pendingFlowModules(Collection<ModuleConfiguration> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copy(pendingFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(ModuleConfiguration ... pendingFlowModules) {
            this.pendingFlowModules(Arrays.asList(pendingFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder> ... pendingFlowModules) {
            this.pendingFlowModules(Stream.of(pendingFlowModules).map(c -> (ModuleConfiguration)((ModuleConfiguration.Builder)ModuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        @Override
        public AcceptLinkResponse build() {
            return new AcceptLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptLinkResponse> {
        public Builder gatewayId(String var1);

        public Builder peerGatewayId(String var1);

        public Builder status(String var1);

        public Builder status(LinkStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder direction(String var1);

        public Builder direction(LinkDirection var1);

        public Builder flowModules(Collection<ModuleConfiguration> var1);

        public Builder flowModules(ModuleConfiguration ... var1);

        public Builder flowModules(Consumer<ModuleConfiguration.Builder> ... var1);

        public Builder pendingFlowModules(Collection<ModuleConfiguration> var1);

        public Builder pendingFlowModules(ModuleConfiguration ... var1);

        public Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder> ... var1);

        public Builder attributes(LinkAttributes var1);

        default public Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return this.attributes((LinkAttributes)((LinkAttributes.Builder)LinkAttributes.builder().applyMutation(attributes)).build());
        }

        public Builder linkId(String var1);
    }
}

