/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponseSecurityGroupIdsListCopier;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponseSubnetIdsListCopier;
import software.amazon.awssdk.services.rtbfabric.model.ManagedEndpointConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.Protocol;
import software.amazon.awssdk.services.rtbfabric.model.ResponderGatewayStatus;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricResponse;
import software.amazon.awssdk.services.rtbfabric.model.TagsMapCopier;
import software.amazon.awssdk.services.rtbfabric.model.TrustStoreConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResponderGatewayResponse
extends RtbFabricResponse
implements ToCopyableBuilder<Builder, GetResponderGatewayResponse> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcId").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::vpcId)).setter(GetResponderGatewayResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::subnetIds)).setter(GetResponderGatewayResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::securityGroupIds)).setter(GetResponderGatewayResponse.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::statusAsString)).setter(GetResponderGatewayResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::description)).setter(GetResponderGatewayResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::createdAt)).setter(GetResponderGatewayResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::updatedAt)).setter(GetResponderGatewayResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::domainName)).setter(GetResponderGatewayResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::port)).setter(GetResponderGatewayResponse.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::protocolAsString)).setter(GetResponderGatewayResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<TrustStoreConfiguration> TRUST_STORE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trustStoreConfiguration").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::trustStoreConfiguration)).setter(GetResponderGatewayResponse.setter(Builder::trustStoreConfiguration)).constructor(TrustStoreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreConfiguration").build()}).build();
    private static final SdkField<ManagedEndpointConfiguration> MANAGED_ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedEndpointConfiguration").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::managedEndpointConfiguration)).setter(GetResponderGatewayResponse.setter(Builder::managedEndpointConfiguration)).constructor(ManagedEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointConfiguration").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::gatewayId)).setter(GetResponderGatewayResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::tags)).setter(GetResponderGatewayResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> ACTIVE_LINKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("activeLinksCount").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::activeLinksCount)).setter(GetResponderGatewayResponse.setter(Builder::activeLinksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeLinksCount").build()}).build();
    private static final SdkField<Integer> TOTAL_LINKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalLinksCount").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::totalLinksCount)).setter(GetResponderGatewayResponse.setter(Builder::totalLinksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalLinksCount").build()}).build();
    private static final SdkField<Integer> INBOUND_LINKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inboundLinksCount").getter(GetResponderGatewayResponse.getter(GetResponderGatewayResponse::inboundLinksCount)).setter(GetResponderGatewayResponse.setter(Builder::inboundLinksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundLinksCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DOMAIN_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, TRUST_STORE_CONFIGURATION_FIELD, MANAGED_ENDPOINT_CONFIGURATION_FIELD, GATEWAY_ID_FIELD, TAGS_FIELD, ACTIVE_LINKS_COUNT_FIELD, TOTAL_LINKS_COUNT_FIELD, INBOUND_LINKS_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResponderGatewayResponse.memberNameToFieldInitializer();
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final String status;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String domainName;
    private final Integer port;
    private final String protocol;
    private final TrustStoreConfiguration trustStoreConfiguration;
    private final ManagedEndpointConfiguration managedEndpointConfiguration;
    private final String gatewayId;
    private final Map<String, String> tags;
    private final Integer activeLinksCount;
    private final Integer totalLinksCount;
    private final Integer inboundLinksCount;

    private GetResponderGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.domainName = builder.domainName;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.trustStoreConfiguration = builder.trustStoreConfiguration;
        this.managedEndpointConfiguration = builder.managedEndpointConfiguration;
        this.gatewayId = builder.gatewayId;
        this.tags = builder.tags;
        this.activeLinksCount = builder.activeLinksCount;
        this.totalLinksCount = builder.totalLinksCount;
        this.inboundLinksCount = builder.inboundLinksCount;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final ResponderGatewayStatus status() {
        return ResponderGatewayStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer port() {
        return this.port;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final TrustStoreConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public final ManagedEndpointConfiguration managedEndpointConfiguration() {
        return this.managedEndpointConfiguration;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer activeLinksCount() {
        return this.activeLinksCount;
    }

    public final Integer totalLinksCount() {
        return this.totalLinksCount;
    }

    public final Integer inboundLinksCount() {
        return this.inboundLinksCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.activeLinksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLinksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundLinksCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResponderGatewayResponse)) {
            return false;
        }
        GetResponderGatewayResponse other = (GetResponderGatewayResponse)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.trustStoreConfiguration(), other.trustStoreConfiguration()) && Objects.equals(this.managedEndpointConfiguration(), other.managedEndpointConfiguration()) && Objects.equals(this.gatewayId(), other.gatewayId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.activeLinksCount(), other.activeLinksCount()) && Objects.equals(this.totalLinksCount(), other.totalLinksCount()) && Objects.equals(this.inboundLinksCount(), other.inboundLinksCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetResponderGatewayResponse").add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DomainName", (Object)this.domainName()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("TrustStoreConfiguration", (Object)this.trustStoreConfiguration()).add("ManagedEndpointConfiguration", (Object)this.managedEndpointConfiguration()).add("GatewayId", (Object)this.gatewayId()).add("Tags", this.hasTags() ? this.tags() : null).add("ActiveLinksCount", (Object)this.activeLinksCount()).add("TotalLinksCount", (Object)this.totalLinksCount()).add("InboundLinksCount", (Object)this.inboundLinksCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "trustStoreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.trustStoreConfiguration()));
            }
            case "managedEndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.managedEndpointConfiguration()));
            }
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "activeLinksCount": {
                return Optional.ofNullable(clazz.cast(this.activeLinksCount()));
            }
            case "totalLinksCount": {
                return Optional.ofNullable(clazz.cast(this.totalLinksCount()));
            }
            case "inboundLinksCount": {
                return Optional.ofNullable(clazz.cast(this.inboundLinksCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vpcId", VPC_ID_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("trustStoreConfiguration", TRUST_STORE_CONFIGURATION_FIELD);
        map.put("managedEndpointConfiguration", MANAGED_ENDPOINT_CONFIGURATION_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("activeLinksCount", ACTIVE_LINKS_COUNT_FIELD);
        map.put("totalLinksCount", TOTAL_LINKS_COUNT_FIELD);
        map.put("inboundLinksCount", INBOUND_LINKS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResponderGatewayResponse, T> g) {
        return obj -> g.apply((GetResponderGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricResponse.BuilderImpl
    implements Builder {
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String domainName;
        private Integer port;
        private String protocol;
        private TrustStoreConfiguration trustStoreConfiguration;
        private ManagedEndpointConfiguration managedEndpointConfiguration;
        private String gatewayId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer activeLinksCount;
        private Integer totalLinksCount;
        private Integer inboundLinksCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResponderGatewayResponse model) {
            super(model);
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.status(model.status);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.domainName(model.domainName);
            this.port(model.port);
            this.protocol(model.protocol);
            this.trustStoreConfiguration(model.trustStoreConfiguration);
            this.managedEndpointConfiguration(model.managedEndpointConfiguration);
            this.gatewayId(model.gatewayId);
            this.tags(model.tags);
            this.activeLinksCount(model.activeLinksCount);
            this.totalLinksCount(model.totalLinksCount);
            this.inboundLinksCount(model.inboundLinksCount);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = GetResponderGatewayResponseSubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = GetResponderGatewayResponseSubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = GetResponderGatewayResponseSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = GetResponderGatewayResponseSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResponderGatewayStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final TrustStoreConfiguration.Builder getTrustStoreConfiguration() {
            return this.trustStoreConfiguration != null ? this.trustStoreConfiguration.toBuilder() : null;
        }

        public final void setTrustStoreConfiguration(TrustStoreConfiguration.BuilderImpl trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration != null ? trustStoreConfiguration.build() : null;
        }

        @Override
        public final Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration;
            return this;
        }

        public final ManagedEndpointConfiguration.Builder getManagedEndpointConfiguration() {
            return this.managedEndpointConfiguration != null ? this.managedEndpointConfiguration.toBuilder() : null;
        }

        public final void setManagedEndpointConfiguration(ManagedEndpointConfiguration.BuilderImpl managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration != null ? managedEndpointConfiguration.build() : null;
        }

        @Override
        public final Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Integer getActiveLinksCount() {
            return this.activeLinksCount;
        }

        public final void setActiveLinksCount(Integer activeLinksCount) {
            this.activeLinksCount = activeLinksCount;
        }

        @Override
        public final Builder activeLinksCount(Integer activeLinksCount) {
            this.activeLinksCount = activeLinksCount;
            return this;
        }

        public final Integer getTotalLinksCount() {
            return this.totalLinksCount;
        }

        public final void setTotalLinksCount(Integer totalLinksCount) {
            this.totalLinksCount = totalLinksCount;
        }

        @Override
        public final Builder totalLinksCount(Integer totalLinksCount) {
            this.totalLinksCount = totalLinksCount;
            return this;
        }

        public final Integer getInboundLinksCount() {
            return this.inboundLinksCount;
        }

        public final void setInboundLinksCount(Integer inboundLinksCount) {
            this.inboundLinksCount = inboundLinksCount;
        }

        @Override
        public final Builder inboundLinksCount(Integer inboundLinksCount) {
            this.inboundLinksCount = inboundLinksCount;
            return this;
        }

        @Override
        public GetResponderGatewayResponse build() {
            return new GetResponderGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResponderGatewayResponse> {
        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder status(String var1);

        public Builder status(ResponderGatewayStatus var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder domainName(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder trustStoreConfiguration(TrustStoreConfiguration var1);

        default public Builder trustStoreConfiguration(Consumer<TrustStoreConfiguration.Builder> trustStoreConfiguration) {
            return this.trustStoreConfiguration((TrustStoreConfiguration)((TrustStoreConfiguration.Builder)TrustStoreConfiguration.builder().applyMutation(trustStoreConfiguration)).build());
        }

        public Builder managedEndpointConfiguration(ManagedEndpointConfiguration var1);

        default public Builder managedEndpointConfiguration(Consumer<ManagedEndpointConfiguration.Builder> managedEndpointConfiguration) {
            return this.managedEndpointConfiguration((ManagedEndpointConfiguration)((ManagedEndpointConfiguration.Builder)ManagedEndpointConfiguration.builder().applyMutation(managedEndpointConfiguration)).build());
        }

        public Builder gatewayId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder activeLinksCount(Integer var1);

        public Builder totalLinksCount(Integer var1);

        public Builder inboundLinksCount(Integer var1);
    }
}

