/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.rtbfabric.RtbFabricClient;
import software.amazon.awssdk.services.rtbfabric.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
@ThreadSafe
final class DefaultRtbFabricWaiter implements RtbFabricWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute<>(SdkAutoCloseable.class);

    private final RtbFabricClient client;

    private final AttributeMap managedResources;

    private final Waiter<GetInboundExternalLinkResponse> inboundExternalLinkActiveWaiter;

    private final Waiter<GetLinkResponse> linkAcceptedWaiter;

    private final Waiter<GetLinkResponse> linkActiveWaiter;

    private final Waiter<GetOutboundExternalLinkResponse> outboundExternalLinkActiveWaiter;

    private final Waiter<GetRequesterGatewayResponse> requesterGatewayActiveWaiter;

    private final Waiter<GetRequesterGatewayResponse> requesterGatewayDeletedWaiter;

    private final Waiter<GetResponderGatewayResponse> responderGatewayActiveWaiter;

    private final Waiter<GetResponderGatewayResponse> responderGatewayDeletedWaiter;

    private DefaultRtbFabricWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = RtbFabricClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client);
        } else {
            this.client = builder.client;
        }
        managedResources = attributeMapBuilder.build();
        this.inboundExternalLinkActiveWaiter = Waiter.builder(GetInboundExternalLinkResponse.class)
                .acceptors(inboundExternalLinkActiveWaiterAcceptors())
                .overrideConfiguration(inboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.linkAcceptedWaiter = Waiter.builder(GetLinkResponse.class).acceptors(linkAcceptedWaiterAcceptors())
                .overrideConfiguration(linkAcceptedWaiterConfig(builder.overrideConfiguration)).build();
        this.linkActiveWaiter = Waiter.builder(GetLinkResponse.class).acceptors(linkActiveWaiterAcceptors())
                .overrideConfiguration(linkActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.outboundExternalLinkActiveWaiter = Waiter.builder(GetOutboundExternalLinkResponse.class)
                .acceptors(outboundExternalLinkActiveWaiterAcceptors())
                .overrideConfiguration(outboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.requesterGatewayActiveWaiter = Waiter.builder(GetRequesterGatewayResponse.class)
                .acceptors(requesterGatewayActiveWaiterAcceptors())
                .overrideConfiguration(requesterGatewayActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.requesterGatewayDeletedWaiter = Waiter.builder(GetRequesterGatewayResponse.class)
                .acceptors(requesterGatewayDeletedWaiterAcceptors())
                .overrideConfiguration(requesterGatewayDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.responderGatewayActiveWaiter = Waiter.builder(GetResponderGatewayResponse.class)
                .acceptors(responderGatewayActiveWaiterAcceptors())
                .overrideConfiguration(responderGatewayActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.responderGatewayDeletedWaiter = Waiter.builder(GetResponderGatewayResponse.class)
                .acceptors(responderGatewayDeletedWaiterAcceptors())
                .overrideConfiguration(responderGatewayDeletedWaiterConfig(builder.overrideConfiguration)).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException) error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetInboundExternalLinkResponse> waitUntilInboundExternalLinkActive(
            GetInboundExternalLinkRequest getInboundExternalLinkRequest) {
        return inboundExternalLinkActiveWaiter.run(() -> client
                .getInboundExternalLink(applyWaitersUserAgent(getInboundExternalLinkRequest)));
    }

    @Override
    public WaiterResponse<GetInboundExternalLinkResponse> waitUntilInboundExternalLinkActive(
            GetInboundExternalLinkRequest getInboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return inboundExternalLinkActiveWaiter.run(
                () -> client.getInboundExternalLink(applyWaitersUserAgent(getInboundExternalLinkRequest)),
                inboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkAccepted(GetLinkRequest getLinkRequest) {
        return linkAcceptedWaiter.run(() -> client.getLink(applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkAccepted(GetLinkRequest getLinkRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return linkAcceptedWaiter.run(() -> client.getLink(applyWaitersUserAgent(getLinkRequest)),
                linkAcceptedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkActive(GetLinkRequest getLinkRequest) {
        return linkActiveWaiter.run(() -> client.getLink(applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkActive(GetLinkRequest getLinkRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return linkActiveWaiter.run(() -> client.getLink(applyWaitersUserAgent(getLinkRequest)),
                linkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetOutboundExternalLinkResponse> waitUntilOutboundExternalLinkActive(
            GetOutboundExternalLinkRequest getOutboundExternalLinkRequest) {
        return outboundExternalLinkActiveWaiter.run(() -> client
                .getOutboundExternalLink(applyWaitersUserAgent(getOutboundExternalLinkRequest)));
    }

    @Override
    public WaiterResponse<GetOutboundExternalLinkResponse> waitUntilOutboundExternalLinkActive(
            GetOutboundExternalLinkRequest getOutboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return outboundExternalLinkActiveWaiter.run(
                () -> client.getOutboundExternalLink(applyWaitersUserAgent(getOutboundExternalLinkRequest)),
                outboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayActive(
            GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return requesterGatewayActiveWaiter.run(() -> client
                .getRequesterGateway(applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayActive(
            GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return requesterGatewayActiveWaiter.run(
                () -> client.getRequesterGateway(applyWaitersUserAgent(getRequesterGatewayRequest)),
                requesterGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayDeleted(
            GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return requesterGatewayDeletedWaiter.run(() -> client
                .getRequesterGateway(applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayDeleted(
            GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return requesterGatewayDeletedWaiter.run(
                () -> client.getRequesterGateway(applyWaitersUserAgent(getRequesterGatewayRequest)),
                requesterGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayActive(
            GetResponderGatewayRequest getResponderGatewayRequest) {
        return responderGatewayActiveWaiter.run(() -> client
                .getResponderGateway(applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayActive(
            GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return responderGatewayActiveWaiter.run(
                () -> client.getResponderGateway(applyWaitersUserAgent(getResponderGatewayRequest)),
                responderGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayDeleted(
            GetResponderGatewayRequest getResponderGatewayRequest) {
        return responderGatewayDeletedWaiter.run(() -> client
                .getResponderGateway(applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayDeleted(
            GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return responderGatewayDeletedWaiter.run(
                () -> client.getResponderGateway(applyWaitersUserAgent(getResponderGatewayRequest)),
                responderGatewayDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetInboundExternalLinkResponse>> inboundExternalLinkActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetInboundExternalLinkResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "REJECTED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "ISOLATED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkAcceptedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACCEPTED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "REJECTED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "REJECTED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> outboundExternalLinkActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "REJECTED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "ISOLATED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "DELETED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration inboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkAcceptedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    @Override
    public void close() {
        managedResources.close();
    }

    public static RtbFabricWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RtbFabricRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    public static final class DefaultBuilder implements RtbFabricWaiter.Builder {
        private RtbFabricClient client;

        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RtbFabricWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RtbFabricWaiter.Builder client(RtbFabricClient client) {
            this.client = client;
            return this;
        }

        public RtbFabricWaiter build() {
            return new DefaultRtbFabricWaiter(this);
        }
    }
}
