/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters of a module.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModuleParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ModuleParameters.Builder, ModuleParameters> {
    private static final SdkField<NoBidModuleParameters> NO_BID_FIELD = SdkField
            .<NoBidModuleParameters> builder(MarshallingType.SDK_POJO).memberName("noBid")
            .getter(getter(ModuleParameters::noBid)).setter(setter(Builder::noBid)).constructor(NoBidModuleParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noBid").build()).build();

    private static final SdkField<OpenRtbAttributeModuleParameters> OPEN_RTB_ATTRIBUTE_FIELD = SdkField
            .<OpenRtbAttributeModuleParameters> builder(MarshallingType.SDK_POJO).memberName("openRtbAttribute")
            .getter(getter(ModuleParameters::openRtbAttribute)).setter(setter(Builder::openRtbAttribute))
            .constructor(OpenRtbAttributeModuleParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openRtbAttribute").build()).build();

    private static final SdkField<RateLimiterModuleParameters> RATE_LIMITER_FIELD = SdkField
            .<RateLimiterModuleParameters> builder(MarshallingType.SDK_POJO).memberName("rateLimiter")
            .getter(getter(ModuleParameters::rateLimiter)).setter(setter(Builder::rateLimiter))
            .constructor(RateLimiterModuleParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateLimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_BID_FIELD,
            OPEN_RTB_ATTRIBUTE_FIELD, RATE_LIMITER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NoBidModuleParameters noBid;

    private final OpenRtbAttributeModuleParameters openRtbAttribute;

    private final RateLimiterModuleParameters rateLimiter;

    private final Type type;

    private ModuleParameters(BuilderImpl builder) {
        this.noBid = builder.noBid;
        this.openRtbAttribute = builder.openRtbAttribute;
        this.rateLimiter = builder.rateLimiter;
        this.type = builder.type;
    }

    /**
     * <p>
     * Describes the parameters of a no bid module.
     * </p>
     * 
     * @return Describes the parameters of a no bid module.
     */
    public final NoBidModuleParameters noBid() {
        return noBid;
    }

    /**
     * <p>
     * Describes the parameters of an open RTB attribute module.
     * </p>
     * 
     * @return Describes the parameters of an open RTB attribute module.
     */
    public final OpenRtbAttributeModuleParameters openRtbAttribute() {
        return openRtbAttribute;
    }

    /**
     * <p>
     * Describes the parameters of a rate limit.
     * </p>
     * 
     * @return Describes the parameters of a rate limit.
     */
    public final RateLimiterModuleParameters rateLimiter() {
        return rateLimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noBid());
        hashCode = 31 * hashCode + Objects.hashCode(openRtbAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleParameters)) {
            return false;
        }
        ModuleParameters other = (ModuleParameters) obj;
        return Objects.equals(noBid(), other.noBid()) && Objects.equals(openRtbAttribute(), other.openRtbAttribute())
                && Objects.equals(rateLimiter(), other.rateLimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModuleParameters").add("NoBid", noBid()).add("OpenRtbAttribute", openRtbAttribute())
                .add("RateLimiter", rateLimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noBid":
            return Optional.ofNullable(clazz.cast(noBid()));
        case "openRtbAttribute":
            return Optional.ofNullable(clazz.cast(openRtbAttribute()));
        case "rateLimiter":
            return Optional.ofNullable(clazz.cast(rateLimiter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #noBid()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of a no bid module.
     * </p>
     * 
     * @param noBid
     *        Describes the parameters of a no bid module.
     */
    public static ModuleParameters fromNoBid(NoBidModuleParameters noBid) {
        return builder().noBid(noBid).build();
    }

    /**
     * Create an instance of this class with {@link #noBid()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of a no bid module.
     * </p>
     * 
     * @param noBid
     *        Describes the parameters of a no bid module.
     */
    public static ModuleParameters fromNoBid(Consumer<NoBidModuleParameters.Builder> noBid) {
        NoBidModuleParameters.Builder builder = NoBidModuleParameters.builder();
        noBid.accept(builder);
        return fromNoBid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #openRtbAttribute()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of an open RTB attribute module.
     * </p>
     * 
     * @param openRtbAttribute
     *        Describes the parameters of an open RTB attribute module.
     */
    public static ModuleParameters fromOpenRtbAttribute(OpenRtbAttributeModuleParameters openRtbAttribute) {
        return builder().openRtbAttribute(openRtbAttribute).build();
    }

    /**
     * Create an instance of this class with {@link #openRtbAttribute()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of an open RTB attribute module.
     * </p>
     * 
     * @param openRtbAttribute
     *        Describes the parameters of an open RTB attribute module.
     */
    public static ModuleParameters fromOpenRtbAttribute(Consumer<OpenRtbAttributeModuleParameters.Builder> openRtbAttribute) {
        OpenRtbAttributeModuleParameters.Builder builder = OpenRtbAttributeModuleParameters.builder();
        openRtbAttribute.accept(builder);
        return fromOpenRtbAttribute(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rateLimiter()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of a rate limit.
     * </p>
     * 
     * @param rateLimiter
     *        Describes the parameters of a rate limit.
     */
    public static ModuleParameters fromRateLimiter(RateLimiterModuleParameters rateLimiter) {
        return builder().rateLimiter(rateLimiter).build();
    }

    /**
     * Create an instance of this class with {@link #rateLimiter()} initialized to the given value.
     *
     * <p>
     * Describes the parameters of a rate limit.
     * </p>
     * 
     * @param rateLimiter
     *        Describes the parameters of a rate limit.
     */
    public static ModuleParameters fromRateLimiter(Consumer<RateLimiterModuleParameters.Builder> rateLimiter) {
        RateLimiterModuleParameters.Builder builder = RateLimiterModuleParameters.builder();
        rateLimiter.accept(builder);
        return fromRateLimiter(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("noBid", NO_BID_FIELD);
        map.put("openRtbAttribute", OPEN_RTB_ATTRIBUTE_FIELD);
        map.put("rateLimiter", RATE_LIMITER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModuleParameters, T> g) {
        return obj -> g.apply((ModuleParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModuleParameters> {
        /**
         * <p>
         * Describes the parameters of a no bid module.
         * </p>
         * 
         * @param noBid
         *        Describes the parameters of a no bid module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noBid(NoBidModuleParameters noBid);

        /**
         * <p>
         * Describes the parameters of a no bid module.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoBidModuleParameters.Builder} avoiding
         * the need to create one manually via {@link NoBidModuleParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoBidModuleParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #noBid(NoBidModuleParameters)}.
         * 
         * @param noBid
         *        a consumer that will call methods on {@link NoBidModuleParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noBid(NoBidModuleParameters)
         */
        default Builder noBid(Consumer<NoBidModuleParameters.Builder> noBid) {
            return noBid(NoBidModuleParameters.builder().applyMutation(noBid).build());
        }

        /**
         * <p>
         * Describes the parameters of an open RTB attribute module.
         * </p>
         * 
         * @param openRtbAttribute
         *        Describes the parameters of an open RTB attribute module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openRtbAttribute(OpenRtbAttributeModuleParameters openRtbAttribute);

        /**
         * <p>
         * Describes the parameters of an open RTB attribute module.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenRtbAttributeModuleParameters.Builder}
         * avoiding the need to create one manually via {@link OpenRtbAttributeModuleParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenRtbAttributeModuleParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #openRtbAttribute(OpenRtbAttributeModuleParameters)}.
         * 
         * @param openRtbAttribute
         *        a consumer that will call methods on {@link OpenRtbAttributeModuleParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openRtbAttribute(OpenRtbAttributeModuleParameters)
         */
        default Builder openRtbAttribute(Consumer<OpenRtbAttributeModuleParameters.Builder> openRtbAttribute) {
            return openRtbAttribute(OpenRtbAttributeModuleParameters.builder().applyMutation(openRtbAttribute).build());
        }

        /**
         * <p>
         * Describes the parameters of a rate limit.
         * </p>
         * 
         * @param rateLimiter
         *        Describes the parameters of a rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimiter(RateLimiterModuleParameters rateLimiter);

        /**
         * <p>
         * Describes the parameters of a rate limit.
         * </p>
         * This is a convenience method that creates an instance of the {@link RateLimiterModuleParameters.Builder}
         * avoiding the need to create one manually via {@link RateLimiterModuleParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RateLimiterModuleParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #rateLimiter(RateLimiterModuleParameters)}.
         * 
         * @param rateLimiter
         *        a consumer that will call methods on {@link RateLimiterModuleParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rateLimiter(RateLimiterModuleParameters)
         */
        default Builder rateLimiter(Consumer<RateLimiterModuleParameters.Builder> rateLimiter) {
            return rateLimiter(RateLimiterModuleParameters.builder().applyMutation(rateLimiter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NoBidModuleParameters noBid;

        private OpenRtbAttributeModuleParameters openRtbAttribute;

        private RateLimiterModuleParameters rateLimiter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleParameters model) {
            noBid(model.noBid);
            openRtbAttribute(model.openRtbAttribute);
            rateLimiter(model.rateLimiter);
        }

        public final NoBidModuleParameters.Builder getNoBid() {
            return noBid != null ? noBid.toBuilder() : null;
        }

        public final void setNoBid(NoBidModuleParameters.BuilderImpl noBid) {
            Object oldValue = this.noBid;
            this.noBid = noBid != null ? noBid.build() : null;
            handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
        }

        @Override
        public final Builder noBid(NoBidModuleParameters noBid) {
            Object oldValue = this.noBid;
            this.noBid = noBid;
            handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
            return this;
        }

        public final OpenRtbAttributeModuleParameters.Builder getOpenRtbAttribute() {
            return openRtbAttribute != null ? openRtbAttribute.toBuilder() : null;
        }

        public final void setOpenRtbAttribute(OpenRtbAttributeModuleParameters.BuilderImpl openRtbAttribute) {
            Object oldValue = this.openRtbAttribute;
            this.openRtbAttribute = openRtbAttribute != null ? openRtbAttribute.build() : null;
            handleUnionValueChange(Type.OPEN_RTB_ATTRIBUTE, oldValue, this.openRtbAttribute);
        }

        @Override
        public final Builder openRtbAttribute(OpenRtbAttributeModuleParameters openRtbAttribute) {
            Object oldValue = this.openRtbAttribute;
            this.openRtbAttribute = openRtbAttribute;
            handleUnionValueChange(Type.OPEN_RTB_ATTRIBUTE, oldValue, this.openRtbAttribute);
            return this;
        }

        public final RateLimiterModuleParameters.Builder getRateLimiter() {
            return rateLimiter != null ? rateLimiter.toBuilder() : null;
        }

        public final void setRateLimiter(RateLimiterModuleParameters.BuilderImpl rateLimiter) {
            Object oldValue = this.rateLimiter;
            this.rateLimiter = rateLimiter != null ? rateLimiter.build() : null;
            handleUnionValueChange(Type.RATE_LIMITER, oldValue, this.rateLimiter);
        }

        @Override
        public final Builder rateLimiter(RateLimiterModuleParameters rateLimiter) {
            Object oldValue = this.rateLimiter;
            this.rateLimiter = rateLimiter;
            handleUnionValueChange(Type.RATE_LIMITER, oldValue, this.rateLimiter);
            return this;
        }

        @Override
        public ModuleParameters build() {
            return new ModuleParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ModuleParameters#type()
     */
    public enum Type {
        NO_BID,

        OPEN_RTB_ATTRIBUTE,

        RATE_LIMITER,

        UNKNOWN_TO_SDK_VERSION
    }
}
