/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLinksResponse extends RtbFabricResponse implements
        ToCopyableBuilder<ListLinksResponse.Builder, ListLinksResponse> {
    private static final SdkField<List<ListLinksResponseStructure>> LINKS_FIELD = SdkField
            .<List<ListLinksResponseStructure>> builder(MarshallingType.LIST)
            .memberName("links")
            .getter(getter(ListLinksResponse::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListLinksResponseStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListLinksResponseStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListLinksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LINKS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ListLinksResponseStructure> links;

    private final String nextToken;

    private ListLinksResponse(BuilderImpl builder) {
        super(builder);
        this.links = builder.links;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Links property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about created links.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinks} method.
     * </p>
     * 
     * @return Information about created links.
     */
    public final List<ListLinksResponseStructure> links() {
        return links;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken error</i>.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLinksResponse)) {
            return false;
        }
        ListLinksResponse other = (ListLinksResponse) obj;
        return hasLinks() == other.hasLinks() && Objects.equals(links(), other.links())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLinksResponse").add("Links", hasLinks() ? links() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "links":
            return Optional.ofNullable(clazz.cast(links()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("links", LINKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLinksResponse, T> g) {
        return obj -> g.apply((ListLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RtbFabricResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLinksResponse> {
        /**
         * <p>
         * Information about created links.
         * </p>
         * 
         * @param links
         *        Information about created links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<ListLinksResponseStructure> links);

        /**
         * <p>
         * Information about created links.
         * </p>
         * 
         * @param links
         *        Information about created links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(ListLinksResponseStructure... links);

        /**
         * <p>
         * Information about created links.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksResponseStructure.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksResponseStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksResponseStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #links(List<ListLinksResponseStructure>)}.
         * 
         * @param links
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rtbfabric.model.ListLinksResponseStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #links(java.util.Collection<ListLinksResponseStructure>)
         */
        Builder links(Consumer<ListLinksResponseStructure.Builder>... links);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken error</i>.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken
         *        error</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RtbFabricResponse.BuilderImpl implements Builder {
        private List<ListLinksResponseStructure> links = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLinksResponse model) {
            super(model);
            links(model.links);
            nextToken(model.nextToken);
        }

        public final List<ListLinksResponseStructure.Builder> getLinks() {
            List<ListLinksResponseStructure.Builder> result = LinkListCopier.copyToBuilder(this.links);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinks(Collection<ListLinksResponseStructure.BuilderImpl> links) {
            this.links = LinkListCopier.copyFromBuilder(links);
        }

        @Override
        public final Builder links(Collection<ListLinksResponseStructure> links) {
            this.links = LinkListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(ListLinksResponseStructure... links) {
            links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<ListLinksResponseStructure.Builder>... links) {
            links(Stream.of(links).map(c -> ListLinksResponseStructure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLinksResponse build() {
            return new ListLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
