/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a link application log sample.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkApplicationLogSampling implements SdkPojo, Serializable,
        ToCopyableBuilder<LinkApplicationLogSampling.Builder, LinkApplicationLogSampling> {
    private static final SdkField<Double> ERROR_LOG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("errorLog").getter(getter(LinkApplicationLogSampling::errorLog)).setter(setter(Builder::errorLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorLog").build()).build();

    private static final SdkField<Double> FILTER_LOG_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("filterLog").getter(getter(LinkApplicationLogSampling::filterLog)).setter(setter(Builder::filterLog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterLog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_LOG_FIELD,
            FILTER_LOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double errorLog;

    private final Double filterLog;

    private LinkApplicationLogSampling(BuilderImpl builder) {
        this.errorLog = builder.errorLog;
        this.filterLog = builder.filterLog;
    }

    /**
     * <p>
     * An error log entry.
     * </p>
     * 
     * @return An error log entry.
     */
    public final Double errorLog() {
        return errorLog;
    }

    /**
     * <p>
     * A filter log entry.
     * </p>
     * 
     * @return A filter log entry.
     */
    public final Double filterLog() {
        return filterLog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorLog());
        hashCode = 31 * hashCode + Objects.hashCode(filterLog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkApplicationLogSampling)) {
            return false;
        }
        LinkApplicationLogSampling other = (LinkApplicationLogSampling) obj;
        return Objects.equals(errorLog(), other.errorLog()) && Objects.equals(filterLog(), other.filterLog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LinkApplicationLogSampling").add("ErrorLog", errorLog()).add("FilterLog", filterLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorLog":
            return Optional.ofNullable(clazz.cast(errorLog()));
        case "filterLog":
            return Optional.ofNullable(clazz.cast(filterLog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorLog", ERROR_LOG_FIELD);
        map.put("filterLog", FILTER_LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LinkApplicationLogSampling, T> g) {
        return obj -> g.apply((LinkApplicationLogSampling) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkApplicationLogSampling> {
        /**
         * <p>
         * An error log entry.
         * </p>
         * 
         * @param errorLog
         *        An error log entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorLog(Double errorLog);

        /**
         * <p>
         * A filter log entry.
         * </p>
         * 
         * @param filterLog
         *        A filter log entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterLog(Double filterLog);
    }

    static final class BuilderImpl implements Builder {
        private Double errorLog;

        private Double filterLog;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkApplicationLogSampling model) {
            errorLog(model.errorLog);
            filterLog(model.filterLog);
        }

        public final Double getErrorLog() {
            return errorLog;
        }

        public final void setErrorLog(Double errorLog) {
            this.errorLog = errorLog;
        }

        @Override
        public final Builder errorLog(Double errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public final Double getFilterLog() {
            return filterLog;
        }

        public final void setFilterLog(Double filterLog) {
            this.filterLog = filterLog;
        }

        @Override
        public final Builder filterLog(Double filterLog) {
            this.filterLog = filterLog;
            return this;
        }

        @Override
        public LinkApplicationLogSampling build() {
            return new LinkApplicationLogSampling(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
