/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an auto scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroupsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroupsConfiguration.Builder, AutoScalingGroupsConfiguration> {
    private static final SdkField<List<String>> AUTO_SCALING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoScalingGroupNames")
            .getter(getter(AutoScalingGroupsConfiguration::autoScalingGroupNames))
            .setter(setter(Builder::autoScalingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AutoScalingGroupsConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_GROUP_NAMES_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> autoScalingGroupNames;

    private final String roleArn;

    private AutoScalingGroupsConfiguration(BuilderImpl builder) {
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.roleArn = builder.roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoScalingGroupNames() {
        return autoScalingGroupNames != null && !(autoScalingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the auto scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingGroupNames} method.
     * </p>
     * 
     * @return The names of the auto scaling group.
     */
    public final List<String> autoScalingGroupNames() {
        return autoScalingGroupNames;
    }

    /**
     * <p>
     * The role ARN of the auto scaling group.
     * </p>
     * 
     * @return The role ARN of the auto scaling group.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoScalingGroupNames() ? autoScalingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupsConfiguration)) {
            return false;
        }
        AutoScalingGroupsConfiguration other = (AutoScalingGroupsConfiguration) obj;
        return hasAutoScalingGroupNames() == other.hasAutoScalingGroupNames()
                && Objects.equals(autoScalingGroupNames(), other.autoScalingGroupNames())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroupsConfiguration")
                .add("AutoScalingGroupNames", hasAutoScalingGroupNames() ? autoScalingGroupNames() : null)
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScalingGroupNames":
            return Optional.ofNullable(clazz.cast(autoScalingGroupNames()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("autoScalingGroupNames", AUTO_SCALING_GROUP_NAMES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupsConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroupsConfiguration> {
        /**
         * <p>
         * The names of the auto scaling group.
         * </p>
         * 
         * @param autoScalingGroupNames
         *        The names of the auto scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames);

        /**
         * <p>
         * The names of the auto scaling group.
         * </p>
         * 
         * @param autoScalingGroupNames
         *        The names of the auto scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupNames(String... autoScalingGroupNames);

        /**
         * <p>
         * The role ARN of the auto scaling group.
         * </p>
         * 
         * @param roleArn
         *        The role ARN of the auto scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupsConfiguration model) {
            autoScalingGroupNames(model.autoScalingGroupNames);
            roleArn(model.roleArn);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            if (autoScalingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return autoScalingGroupNames;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNameListCopier.copy(autoScalingGroupNames);
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNameListCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String... autoScalingGroupNames) {
            autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AutoScalingGroupsConfiguration build() {
            return new AutoScalingGroupsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
