/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.LinkAttributes;
import software.amazon.awssdk.services.rtbfabric.model.LinkStatus;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.ModuleConfigurationListCopier;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricResponse;
import software.amazon.awssdk.services.rtbfabric.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInboundExternalLinkResponse
extends RtbFabricResponse
implements ToCopyableBuilder<Builder, GetInboundExternalLinkResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::gatewayId)).setter(GetInboundExternalLinkResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linkId").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::linkId)).setter(GetInboundExternalLinkResponse.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::statusAsString)).setter(GetInboundExternalLinkResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::domainName)).setter(GetInboundExternalLinkResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<ModuleConfiguration>> FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("flowModules").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::flowModules)).setter(GetInboundExternalLinkResponse.setter(Builder::flowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModuleConfiguration>> PENDING_FLOW_MODULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pendingFlowModules").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::pendingFlowModules)).setter(GetInboundExternalLinkResponse.setter(Builder::pendingFlowModules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingFlowModules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LinkAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributes").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::attributes)).setter(GetInboundExternalLinkResponse.setter(Builder::attributes)).constructor(LinkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::createdAt)).setter(GetInboundExternalLinkResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::updatedAt)).setter(GetInboundExternalLinkResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetInboundExternalLinkResponse.getter(GetInboundExternalLinkResponse::tags)).setter(GetInboundExternalLinkResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, LINK_ID_FIELD, STATUS_FIELD, DOMAIN_NAME_FIELD, FLOW_MODULES_FIELD, PENDING_FLOW_MODULES_FIELD, ATTRIBUTES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInboundExternalLinkResponse.memberNameToFieldInitializer();
    private final String gatewayId;
    private final String linkId;
    private final String status;
    private final String domainName;
    private final List<ModuleConfiguration> flowModules;
    private final List<ModuleConfiguration> pendingFlowModules;
    private final LinkAttributes attributes;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;

    private GetInboundExternalLinkResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.status = builder.status;
        this.domainName = builder.domainName;
        this.flowModules = builder.flowModules;
        this.pendingFlowModules = builder.pendingFlowModules;
        this.attributes = builder.attributes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final LinkStatus status() {
        return LinkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasFlowModules() {
        return this.flowModules != null && !(this.flowModules instanceof SdkAutoConstructList);
    }

    public final List<ModuleConfiguration> flowModules() {
        return this.flowModules;
    }

    public final boolean hasPendingFlowModules() {
        return this.pendingFlowModules != null && !(this.pendingFlowModules instanceof SdkAutoConstructList);
    }

    public final List<ModuleConfiguration> pendingFlowModules() {
        return this.pendingFlowModules;
    }

    public final LinkAttributes attributes() {
        return this.attributes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlowModules() ? this.flowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingFlowModules() ? this.pendingFlowModules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInboundExternalLinkResponse)) {
            return false;
        }
        GetInboundExternalLinkResponse other = (GetInboundExternalLinkResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.domainName(), other.domainName()) && this.hasFlowModules() == other.hasFlowModules() && Objects.equals(this.flowModules(), other.flowModules()) && this.hasPendingFlowModules() == other.hasPendingFlowModules() && Objects.equals(this.pendingFlowModules(), other.pendingFlowModules()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetInboundExternalLinkResponse").add("GatewayId", (Object)this.gatewayId()).add("LinkId", (Object)this.linkId()).add("Status", (Object)this.statusAsString()).add("DomainName", (Object)this.domainName()).add("FlowModules", this.hasFlowModules() ? this.flowModules() : null).add("PendingFlowModules", this.hasPendingFlowModules() ? this.pendingFlowModules() : null).add("Attributes", (Object)this.attributes()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "linkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "flowModules": {
                return Optional.ofNullable(clazz.cast(this.flowModules()));
            }
            case "pendingFlowModules": {
                return Optional.ofNullable(clazz.cast(this.pendingFlowModules()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("flowModules", FLOW_MODULES_FIELD);
        map.put("pendingFlowModules", PENDING_FLOW_MODULES_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInboundExternalLinkResponse, T> g) {
        return obj -> g.apply((GetInboundExternalLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String linkId;
        private String status;
        private String domainName;
        private List<ModuleConfiguration> flowModules = DefaultSdkAutoConstructList.getInstance();
        private List<ModuleConfiguration> pendingFlowModules = DefaultSdkAutoConstructList.getInstance();
        private LinkAttributes attributes;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInboundExternalLinkResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.linkId(model.linkId);
            this.status(model.status);
            this.domainName(model.domainName);
            this.flowModules(model.flowModules);
            this.pendingFlowModules(model.pendingFlowModules);
            this.attributes(model.attributes);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LinkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<ModuleConfiguration.Builder> getFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.flowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowModules(Collection<ModuleConfiguration.BuilderImpl> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copyFromBuilder(flowModules);
        }

        @Override
        public final Builder flowModules(Collection<ModuleConfiguration> flowModules) {
            this.flowModules = ModuleConfigurationListCopier.copy(flowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(ModuleConfiguration ... flowModules) {
            this.flowModules(Arrays.asList(flowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowModules(Consumer<ModuleConfiguration.Builder> ... flowModules) {
            this.flowModules(Stream.of(flowModules).map(c -> (ModuleConfiguration)((ModuleConfiguration.Builder)ModuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModuleConfiguration.Builder> getPendingFlowModules() {
            List<ModuleConfiguration.Builder> result = ModuleConfigurationListCopier.copyToBuilder(this.pendingFlowModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingFlowModules(Collection<ModuleConfiguration.BuilderImpl> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copyFromBuilder(pendingFlowModules);
        }

        @Override
        public final Builder pendingFlowModules(Collection<ModuleConfiguration> pendingFlowModules) {
            this.pendingFlowModules = ModuleConfigurationListCopier.copy(pendingFlowModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(ModuleConfiguration ... pendingFlowModules) {
            this.pendingFlowModules(Arrays.asList(pendingFlowModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder> ... pendingFlowModules) {
            this.pendingFlowModules(Stream.of(pendingFlowModules).map(c -> (ModuleConfiguration)((ModuleConfiguration.Builder)ModuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LinkAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(LinkAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(LinkAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetInboundExternalLinkResponse build() {
            return new GetInboundExternalLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInboundExternalLinkResponse> {
        public Builder gatewayId(String var1);

        public Builder linkId(String var1);

        public Builder status(String var1);

        public Builder status(LinkStatus var1);

        public Builder domainName(String var1);

        public Builder flowModules(Collection<ModuleConfiguration> var1);

        public Builder flowModules(ModuleConfiguration ... var1);

        public Builder flowModules(Consumer<ModuleConfiguration.Builder> ... var1);

        public Builder pendingFlowModules(Collection<ModuleConfiguration> var1);

        public Builder pendingFlowModules(ModuleConfiguration ... var1);

        public Builder pendingFlowModules(Consumer<ModuleConfiguration.Builder> ... var1);

        public Builder attributes(LinkAttributes var1);

        default public Builder attributes(Consumer<LinkAttributes.Builder> attributes) {
            return this.attributes((LinkAttributes)((LinkAttributes.Builder)LinkAttributes.builder().applyMutation(attributes)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

