/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverRuleRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateResolverRuleRequest> {
    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateResolverRuleRequest.getter(UpdateResolverRuleRequest::resolverRuleId)).setter(UpdateResolverRuleRequest.setter(Builder::resolverRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()}).build();
    private static final SdkField<ResolverRuleConfig> CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateResolverRuleRequest.getter(UpdateResolverRuleRequest::config)).setter(UpdateResolverRuleRequest.setter(Builder::config)).constructor(ResolverRuleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_RULE_ID_FIELD, CONFIG_FIELD));
    private final String resolverRuleId;
    private final ResolverRuleConfig config;

    private UpdateResolverRuleRequest(BuilderImpl builder) {
        super(builder);
        this.resolverRuleId = builder.resolverRuleId;
        this.config = builder.config;
    }

    public String resolverRuleId() {
        return this.resolverRuleId;
    }

    public ResolverRuleConfig config() {
        return this.config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverRuleRequest)) {
            return false;
        }
        UpdateResolverRuleRequest other = (UpdateResolverRuleRequest)((Object)obj);
        return Objects.equals(this.resolverRuleId(), other.resolverRuleId()) && Objects.equals(this.config(), other.config());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResolverRuleRequest").add("ResolverRuleId", (Object)this.resolverRuleId()).add("Config", (Object)this.config()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResolverRuleId": {
                return Optional.ofNullable(clazz.cast(this.resolverRuleId()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverRuleRequest, T> g) {
        return obj -> g.apply((UpdateResolverRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resolverRuleId;
        private ResolverRuleConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverRuleRequest model) {
            super(model);
            this.resolverRuleId(model.resolverRuleId);
            this.config(model.config);
        }

        public final String getResolverRuleId() {
            return this.resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        public final ResolverRuleConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        @Override
        public final Builder config(ResolverRuleConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(ResolverRuleConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverRuleRequest build() {
            return new UpdateResolverRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverRuleRequest> {
        public Builder resolverRuleId(String var1);

        public Builder config(ResolverRuleConfig var1);

        default public Builder config(Consumer<ResolverRuleConfig.Builder> config) {
            return this.config((ResolverRuleConfig)((ResolverRuleConfig.Builder)ResolverRuleConfig.builder().applyMutation(config)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

