/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.FirewallRule;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse;

public class ListFirewallRulesIterable
implements SdkIterable<ListFirewallRulesResponse> {
    private final Route53ResolverClient client;
    private final ListFirewallRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallRulesIterable(Route53ResolverClient client, ListFirewallRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFirewallRulesResponseFetcher();
    }

    public Iterator<ListFirewallRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallRule> firewallRules() {
        Function<ListFirewallRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRules() != null) {
                return response.firewallRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallRulesResponseFetcher
    implements SyncPageFetcher<ListFirewallRulesResponse> {
        private ListFirewallRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallRulesResponse nextPage(ListFirewallRulesResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRulesIterable.this.client.listFirewallRules(ListFirewallRulesIterable.this.firstRequest);
            }
            return ListFirewallRulesIterable.this.client.listFirewallRules((ListFirewallRulesRequest)((Object)ListFirewallRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

