/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadataListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallRuleGroupsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallRuleGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallRuleGroupsResponse.getter(ListFirewallRuleGroupsResponse::nextToken)).setter(ListFirewallRuleGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallRuleGroupMetadata>> FIREWALL_RULE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallRuleGroups").getter(ListFirewallRuleGroupsResponse.getter(ListFirewallRuleGroupsResponse::firewallRuleGroups)).setter(ListFirewallRuleGroupsResponse.setter(Builder::firewallRuleGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallRuleGroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_RULE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFirewallRuleGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FirewallRuleGroupMetadata> firewallRuleGroups;

    private ListFirewallRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRuleGroups = builder.firewallRuleGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallRuleGroups() {
        return this.firewallRuleGroups != null && !(this.firewallRuleGroups instanceof SdkAutoConstructList);
    }

    public final List<FirewallRuleGroupMetadata> firewallRuleGroups() {
        return this.firewallRuleGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallRuleGroups() ? this.firewallRuleGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRuleGroupsResponse)) {
            return false;
        }
        ListFirewallRuleGroupsResponse other = (ListFirewallRuleGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallRuleGroups() == other.hasFirewallRuleGroups() && Objects.equals(this.firewallRuleGroups(), other.firewallRuleGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallRuleGroupsResponse").add("NextToken", (Object)this.nextToken()).add("FirewallRuleGroups", this.hasFirewallRuleGroups() ? this.firewallRuleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FirewallRuleGroups": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FirewallRuleGroups", FIREWALL_RULE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListFirewallRuleGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallRuleGroupMetadata> firewallRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRuleGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallRuleGroups(model.firewallRuleGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallRuleGroupMetadata.Builder> getFirewallRuleGroups() {
            List<FirewallRuleGroupMetadata.Builder> result = FirewallRuleGroupMetadataListCopier.copyToBuilder(this.firewallRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallRuleGroups(Collection<FirewallRuleGroupMetadata.BuilderImpl> firewallRuleGroups) {
            this.firewallRuleGroups = FirewallRuleGroupMetadataListCopier.copyFromBuilder(firewallRuleGroups);
        }

        @Override
        public final Builder firewallRuleGroups(Collection<FirewallRuleGroupMetadata> firewallRuleGroups) {
            this.firewallRuleGroups = FirewallRuleGroupMetadataListCopier.copy(firewallRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroups(FirewallRuleGroupMetadata ... firewallRuleGroups) {
            this.firewallRuleGroups(Arrays.asList(firewallRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroups(Consumer<FirewallRuleGroupMetadata.Builder> ... firewallRuleGroups) {
            this.firewallRuleGroups(Stream.of(firewallRuleGroups).map(c -> (FirewallRuleGroupMetadata)((FirewallRuleGroupMetadata.Builder)FirewallRuleGroupMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallRuleGroupsResponse build() {
            return new ListFirewallRuleGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallRuleGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder firewallRuleGroups(Collection<FirewallRuleGroupMetadata> var1);

        public Builder firewallRuleGroups(FirewallRuleGroupMetadata ... var1);

        public Builder firewallRuleGroups(Consumer<FirewallRuleGroupMetadata.Builder> ... var1);
    }
}

