/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateResolverQueryLogConfigRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, DisassociateResolverQueryLogConfigRequest> {
    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverQueryLogConfigId").getter(DisassociateResolverQueryLogConfigRequest.getter(DisassociateResolverQueryLogConfigRequest::resolverQueryLogConfigId)).setter(DisassociateResolverQueryLogConfigRequest.setter(Builder::resolverQueryLogConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DisassociateResolverQueryLogConfigRequest.getter(DisassociateResolverQueryLogConfigRequest::resourceId)).setter(DisassociateResolverQueryLogConfigRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_QUERY_LOG_CONFIG_ID_FIELD, RESOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateResolverQueryLogConfigRequest.memberNameToFieldInitializer();
    private final String resolverQueryLogConfigId;
    private final String resourceId;

    private DisassociateResolverQueryLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resolverQueryLogConfigId = builder.resolverQueryLogConfigId;
        this.resourceId = builder.resourceId;
    }

    public final String resolverQueryLogConfigId() {
        return this.resolverQueryLogConfigId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverQueryLogConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResolverQueryLogConfigRequest)) {
            return false;
        }
        DisassociateResolverQueryLogConfigRequest other = (DisassociateResolverQueryLogConfigRequest)((Object)obj);
        return Objects.equals(this.resolverQueryLogConfigId(), other.resolverQueryLogConfigId()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateResolverQueryLogConfigRequest").add("ResolverQueryLogConfigId", (Object)this.resolverQueryLogConfigId()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResolverQueryLogConfigId": {
                return Optional.ofNullable(clazz.cast(this.resolverQueryLogConfigId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResolverQueryLogConfigId", RESOLVER_QUERY_LOG_CONFIG_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResolverQueryLogConfigRequest, T> g) {
        return obj -> g.apply((DisassociateResolverQueryLogConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resolverQueryLogConfigId;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResolverQueryLogConfigRequest model) {
            super(model);
            this.resolverQueryLogConfigId(model.resolverQueryLogConfigId);
            this.resourceId(model.resourceId);
        }

        public final String getResolverQueryLogConfigId() {
            return this.resolverQueryLogConfigId;
        }

        public final void setResolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
        }

        @Override
        public final Builder resolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateResolverQueryLogConfigRequest build() {
            return new DisassociateResolverQueryLogConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateResolverQueryLogConfigRequest> {
        public Builder resolverQueryLogConfigId(String var1);

        public Builder resourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

