/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.Protocol;
import software.amazon.awssdk.services.route53resolver.model.ProtocolListCopier;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointType;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.UpdateIpAddress;
import software.amazon.awssdk.services.route53resolver.model.UpdateIpAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverEndpointRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateResolverEndpointRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointId").getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::resolverEndpointId)).setter(UpdateResolverEndpointRequest.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::name)).setter(UpdateResolverEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RESOLVER_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverEndpointType").getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::resolverEndpointTypeAsString)).setter(UpdateResolverEndpointRequest.setter(Builder::resolverEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointType").build()}).build();
    private static final SdkField<List<UpdateIpAddress>> UPDATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpdateIpAddresses").getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::updateIpAddresses)).setter(UpdateResolverEndpointRequest.setter(Builder::updateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(UpdateResolverEndpointRequest.getter(UpdateResolverEndpointRequest::protocolsAsStrings)).setter(UpdateResolverEndpointRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD, NAME_FIELD, RESOLVER_ENDPOINT_TYPE_FIELD, UPDATE_IP_ADDRESSES_FIELD, PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResolverEndpointRequest.memberNameToFieldInitializer();
    private final String resolverEndpointId;
    private final String name;
    private final String resolverEndpointType;
    private final List<UpdateIpAddress> updateIpAddresses;
    private final List<String> protocols;

    private UpdateResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
        this.name = builder.name;
        this.resolverEndpointType = builder.resolverEndpointType;
        this.updateIpAddresses = builder.updateIpAddresses;
        this.protocols = builder.protocols;
    }

    public final String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public final String name() {
        return this.name;
    }

    public final ResolverEndpointType resolverEndpointType() {
        return ResolverEndpointType.fromValue(this.resolverEndpointType);
    }

    public final String resolverEndpointTypeAsString() {
        return this.resolverEndpointType;
    }

    public final boolean hasUpdateIpAddresses() {
        return this.updateIpAddresses != null && !(this.updateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<UpdateIpAddress> updateIpAddresses() {
        return this.updateIpAddresses;
    }

    public final List<Protocol> protocols() {
        return ProtocolListCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateIpAddresses() ? this.updateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverEndpointRequest)) {
            return false;
        }
        UpdateResolverEndpointRequest other = (UpdateResolverEndpointRequest)((Object)obj);
        return Objects.equals(this.resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resolverEndpointTypeAsString(), other.resolverEndpointTypeAsString()) && this.hasUpdateIpAddresses() == other.hasUpdateIpAddresses() && Objects.equals(this.updateIpAddresses(), other.updateIpAddresses()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResolverEndpointRequest").add("ResolverEndpointId", (Object)this.resolverEndpointId()).add("Name", (Object)this.name()).add("ResolverEndpointType", (Object)this.resolverEndpointTypeAsString()).add("UpdateIpAddresses", this.hasUpdateIpAddresses() ? this.updateIpAddresses() : null).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResolverEndpointType": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointTypeAsString()));
            }
            case "UpdateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.updateIpAddresses()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResolverEndpointId", RESOLVER_ENDPOINT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResolverEndpointType", RESOLVER_ENDPOINT_TYPE_FIELD);
        map.put("UpdateIpAddresses", UPDATE_IP_ADDRESSES_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverEndpointRequest, T> g) {
        return obj -> g.apply((UpdateResolverEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resolverEndpointId;
        private String name;
        private String resolverEndpointType;
        private List<UpdateIpAddress> updateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverEndpointRequest model) {
            super(model);
            this.resolverEndpointId(model.resolverEndpointId);
            this.name(model.name);
            this.resolverEndpointType(model.resolverEndpointType);
            this.updateIpAddresses(model.updateIpAddresses);
            this.protocolsWithStrings(model.protocols);
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolverEndpointType() {
            return this.resolverEndpointType;
        }

        public final void setResolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
        }

        @Override
        public final Builder resolverEndpointType(String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
            return this;
        }

        @Override
        public final Builder resolverEndpointType(ResolverEndpointType resolverEndpointType) {
            this.resolverEndpointType(resolverEndpointType == null ? null : resolverEndpointType.toString());
            return this;
        }

        public final List<UpdateIpAddress.Builder> getUpdateIpAddresses() {
            List<UpdateIpAddress.Builder> result = UpdateIpAddressesCopier.copyToBuilder(this.updateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateIpAddresses(Collection<UpdateIpAddress.BuilderImpl> updateIpAddresses) {
            this.updateIpAddresses = UpdateIpAddressesCopier.copyFromBuilder(updateIpAddresses);
        }

        @Override
        public final Builder updateIpAddresses(Collection<UpdateIpAddress> updateIpAddresses) {
            this.updateIpAddresses = UpdateIpAddressesCopier.copy(updateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIpAddresses(UpdateIpAddress ... updateIpAddresses) {
            this.updateIpAddresses(Arrays.asList(updateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIpAddresses(Consumer<UpdateIpAddress.Builder> ... updateIpAddresses) {
            this.updateIpAddresses(Stream.of(updateIpAddresses).map(c -> (UpdateIpAddress)((UpdateIpAddress.Builder)UpdateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolListCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverEndpointRequest build() {
            return new UpdateResolverEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverEndpointRequest> {
        public Builder resolverEndpointId(String var1);

        public Builder name(String var1);

        public Builder resolverEndpointType(String var1);

        public Builder resolverEndpointType(ResolverEndpointType var1);

        public Builder updateIpAddresses(Collection<UpdateIpAddress> var1);

        public Builder updateIpAddresses(UpdateIpAddress ... var1);

        public Builder updateIpAddresses(Consumer<UpdateIpAddress.Builder> ... var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

