/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53resolver.auth.scheme.Route53ResolverAuthSchemeParams;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultRoute53ResolverAuthSchemeParams
implements Route53ResolverAuthSchemeParams {
    private final String operation;
    private final Region region;

    private DefaultRoute53ResolverAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
    }

    public static Route53ResolverAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public Route53ResolverAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements Route53ResolverAuthSchemeParams.Builder {
        private String operation;
        private Region region;

        Builder() {
        }

        Builder(DefaultRoute53ResolverAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Route53ResolverAuthSchemeParams build() {
            return new DefaultRoute53ResolverAuthSchemeParams(this);
        }
    }
}

