/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociationError;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverQueryLogConfigAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverQueryLogConfigAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::id)).setter(ResolverQueryLogConfigAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverQueryLogConfigId").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::resolverQueryLogConfigId)).setter(ResolverQueryLogConfigAssociation.setter(Builder::resolverQueryLogConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::resourceId)).setter(ResolverQueryLogConfigAssociation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::statusAsString)).setter(ResolverQueryLogConfigAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::errorAsString)).setter(ResolverQueryLogConfigAssociation.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::errorMessage)).setter(ResolverQueryLogConfigAssociation.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(ResolverQueryLogConfigAssociation.getter(ResolverQueryLogConfigAssociation::creationTime)).setter(ResolverQueryLogConfigAssociation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOLVER_QUERY_LOG_CONFIG_ID_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, ERROR_FIELD, ERROR_MESSAGE_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolverQueryLogConfigAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resolverQueryLogConfigId;
    private final String resourceId;
    private final String status;
    private final String error;
    private final String errorMessage;
    private final String creationTime;

    private ResolverQueryLogConfigAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.resolverQueryLogConfigId = builder.resolverQueryLogConfigId;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.error = builder.error;
        this.errorMessage = builder.errorMessage;
        this.creationTime = builder.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String resolverQueryLogConfigId() {
        return this.resolverQueryLogConfigId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ResolverQueryLogConfigAssociationStatus status() {
        return ResolverQueryLogConfigAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ResolverQueryLogConfigAssociationError error() {
        return ResolverQueryLogConfigAssociationError.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverQueryLogConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverQueryLogConfigAssociation)) {
            return false;
        }
        ResolverQueryLogConfigAssociation other = (ResolverQueryLogConfigAssociation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resolverQueryLogConfigId(), other.resolverQueryLogConfigId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorAsString(), other.errorAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"ResolverQueryLogConfigAssociation").add("Id", (Object)this.id()).add("ResolverQueryLogConfigId", (Object)this.resolverQueryLogConfigId()).add("ResourceId", (Object)this.resourceId()).add("Status", (Object)this.statusAsString()).add("Error", (Object)this.errorAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ResolverQueryLogConfigId": {
                return Optional.ofNullable(clazz.cast(this.resolverQueryLogConfigId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("ResolverQueryLogConfigId", RESOLVER_QUERY_LOG_CONFIG_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverQueryLogConfigAssociation, T> g) {
        return obj -> g.apply((ResolverQueryLogConfigAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resolverQueryLogConfigId;
        private String resourceId;
        private String status;
        private String error;
        private String errorMessage;
        private String creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverQueryLogConfigAssociation model) {
            this.id(model.id);
            this.resolverQueryLogConfigId(model.resolverQueryLogConfigId);
            this.resourceId(model.resourceId);
            this.status(model.status);
            this.error(model.error);
            this.errorMessage(model.errorMessage);
            this.creationTime(model.creationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResolverQueryLogConfigId() {
            return this.resolverQueryLogConfigId;
        }

        public final void setResolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
        }

        @Override
        public final Builder resolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverQueryLogConfigAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ResolverQueryLogConfigAssociationError error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public ResolverQueryLogConfigAssociation build() {
            return new ResolverQueryLogConfigAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverQueryLogConfigAssociation> {
        public Builder id(String var1);

        public Builder resolverQueryLogConfigId(String var1);

        public Builder resourceId(String var1);

        public Builder status(String var1);

        public Builder status(ResolverQueryLogConfigAssociationStatus var1);

        public Builder error(String var1);

        public Builder error(ResolverQueryLogConfigAssociationError var1);

        public Builder errorMessage(String var1);

        public Builder creationTime(String var1);
    }
}

