/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.IpAddressStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAddressResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAddressResponse> {
    private static final SdkField<String> IP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpId").getter(IpAddressResponse.getter(IpAddressResponse::ipId)).setter(IpAddressResponse.setter(Builder::ipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(IpAddressResponse.getter(IpAddressResponse::subnetId)).setter(IpAddressResponse.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(IpAddressResponse.getter(IpAddressResponse::ip)).setter(IpAddressResponse.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<String> IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6").getter(IpAddressResponse.getter(IpAddressResponse::ipv6)).setter(IpAddressResponse.setter(Builder::ipv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IpAddressResponse.getter(IpAddressResponse::statusAsString)).setter(IpAddressResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(IpAddressResponse.getter(IpAddressResponse::statusMessage)).setter(IpAddressResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(IpAddressResponse.getter(IpAddressResponse::creationTime)).setter(IpAddressResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(IpAddressResponse.getter(IpAddressResponse::modificationTime)).setter(IpAddressResponse.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ID_FIELD, SUBNET_ID_FIELD, IP_FIELD, IPV6_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpAddressResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipId;
    private final String subnetId;
    private final String ip;
    private final String ipv6;
    private final String status;
    private final String statusMessage;
    private final String creationTime;
    private final String modificationTime;

    private IpAddressResponse(BuilderImpl builder) {
        this.ipId = builder.ipId;
        this.subnetId = builder.subnetId;
        this.ip = builder.ip;
        this.ipv6 = builder.ipv6;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public final String ipId() {
        return this.ipId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String ip() {
        return this.ip;
    }

    public final String ipv6() {
        return this.ipv6;
    }

    public final IpAddressStatus status() {
        return IpAddressStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressResponse)) {
            return false;
        }
        IpAddressResponse other = (IpAddressResponse)obj;
        return Objects.equals(this.ipId(), other.ipId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.ip(), other.ip()) && Objects.equals(this.ipv6(), other.ipv6()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"IpAddressResponse").add("IpId", (Object)this.ipId()).add("SubnetId", (Object)this.subnetId()).add("Ip", (Object)this.ip()).add("Ipv6", (Object)this.ipv6()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpId": {
                return Optional.ofNullable(clazz.cast(this.ipId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Ipv6": {
                return Optional.ofNullable(clazz.cast(this.ipv6()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IpId", IP_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Ip", IP_FIELD);
        map.put("Ipv6", IPV6_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAddressResponse, T> g) {
        return obj -> g.apply((IpAddressResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipId;
        private String subnetId;
        private String ip;
        private String ipv6;
        private String status;
        private String statusMessage;
        private String creationTime;
        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressResponse model) {
            this.ipId(model.ipId);
            this.subnetId(model.subnetId);
            this.ip(model.ip);
            this.ipv6(model.ipv6);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
        }

        public final String getIpId() {
            return this.ipId;
        }

        public final void setIpId(String ipId) {
            this.ipId = ipId;
        }

        @Override
        public final Builder ipId(String ipId) {
            this.ipId = ipId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getIpv6() {
            return this.ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpAddressStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public IpAddressResponse build() {
            return new IpAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAddressResponse> {
        public Builder ipId(String var1);

        public Builder subnetId(String var1);

        public Builder ip(String var1);

        public Builder ipv6(String var1);

        public Builder status(String var1);

        public Builder status(IpAddressStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);
    }
}

