/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.Validation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverDnssecConfigRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateResolverDnssecConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(UpdateResolverDnssecConfigRequest.getter(UpdateResolverDnssecConfigRequest::resourceId)).setter(UpdateResolverDnssecConfigRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Validation").getter(UpdateResolverDnssecConfigRequest.getter(UpdateResolverDnssecConfigRequest::validationAsString)).setter(UpdateResolverDnssecConfigRequest.setter(Builder::validation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("Validation", VALIDATION_FIELD);
        }
    });
    private final String resourceId;
    private final String validation;

    private UpdateResolverDnssecConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.validation = builder.validation;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Validation validation() {
        return Validation.fromValue(this.validation);
    }

    public final String validationAsString() {
        return this.validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverDnssecConfigRequest)) {
            return false;
        }
        UpdateResolverDnssecConfigRequest other = (UpdateResolverDnssecConfigRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.validationAsString(), other.validationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResolverDnssecConfigRequest").add("ResourceId", (Object)this.resourceId()).add("Validation", (Object)this.validationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Validation": {
                return Optional.ofNullable(clazz.cast(this.validationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverDnssecConfigRequest, T> g) {
        return obj -> g.apply((UpdateResolverDnssecConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String validation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverDnssecConfigRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.validation(model.validation);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getValidation() {
            return this.validation;
        }

        public final void setValidation(String validation) {
            this.validation = validation;
        }

        @Override
        public final Builder validation(String validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation(validation == null ? null : validation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverDnssecConfigRequest build() {
            return new UpdateResolverDnssecConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverDnssecConfigRequest> {
        public Builder resourceId(String var1);

        public Builder validation(String var1);

        public Builder validation(Validation var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

