/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Action;
import software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType;
import software.amazon.awssdk.services.route53resolver.model.BlockResponse;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainRedirectionAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallRule> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallRuleGroupId").getter(FirewallRule.getter(FirewallRule::firewallRuleGroupId)).setter(FirewallRule.setter(Builder::firewallRuleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build()}).build();
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallDomainListId").getter(FirewallRule.getter(FirewallRule::firewallDomainListId)).setter(FirewallRule.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallRule.getter(FirewallRule::name)).setter(FirewallRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(FirewallRule.getter(FirewallRule::priority)).setter(FirewallRule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(FirewallRule.getter(FirewallRule::actionAsString)).setter(FirewallRule.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockResponse").getter(FirewallRule.getter(FirewallRule::blockResponseAsString)).setter(FirewallRule.setter(Builder::blockResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockResponse").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockOverrideDomain").getter(FirewallRule.getter(FirewallRule::blockOverrideDomain)).setter(FirewallRule.setter(Builder::blockOverrideDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDomain").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockOverrideDnsType").getter(FirewallRule.getter(FirewallRule::blockOverrideDnsTypeAsString)).setter(FirewallRule.setter(Builder::blockOverrideDnsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDnsType").build()}).build();
    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockOverrideTtl").getter(FirewallRule.getter(FirewallRule::blockOverrideTtl)).setter(FirewallRule.setter(Builder::blockOverrideTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideTtl").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(FirewallRule.getter(FirewallRule::creatorRequestId)).setter(FirewallRule.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(FirewallRule.getter(FirewallRule::creationTime)).setter(FirewallRule.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(FirewallRule.getter(FirewallRule::modificationTime)).setter(FirewallRule.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final SdkField<String> FIREWALL_DOMAIN_REDIRECTION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallDomainRedirectionAction").getter(FirewallRule.getter(FirewallRule::firewallDomainRedirectionActionAsString)).setter(FirewallRule.setter(Builder::firewallDomainRedirectionAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainRedirectionAction").build()}).build();
    private static final SdkField<String> QTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qtype").getter(FirewallRule.getter(FirewallRule::qtype)).setter(FirewallRule.setter(Builder::qtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qtype").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ID_FIELD, FIREWALL_DOMAIN_LIST_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, ACTION_FIELD, BLOCK_RESPONSE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_TTL_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD, FIREWALL_DOMAIN_REDIRECTION_ACTION_FIELD, QTYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FirewallRuleGroupId", FIREWALL_RULE_GROUP_ID_FIELD);
            this.put("FirewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Priority", PRIORITY_FIELD);
            this.put("Action", ACTION_FIELD);
            this.put("BlockResponse", BLOCK_RESPONSE_FIELD);
            this.put("BlockOverrideDomain", BLOCK_OVERRIDE_DOMAIN_FIELD);
            this.put("BlockOverrideDnsType", BLOCK_OVERRIDE_DNS_TYPE_FIELD);
            this.put("BlockOverrideTtl", BLOCK_OVERRIDE_TTL_FIELD);
            this.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ModificationTime", MODIFICATION_TIME_FIELD);
            this.put("FirewallDomainRedirectionAction", FIREWALL_DOMAIN_REDIRECTION_ACTION_FIELD);
            this.put("Qtype", QTYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String firewallRuleGroupId;
    private final String firewallDomainListId;
    private final String name;
    private final Integer priority;
    private final String action;
    private final String blockResponse;
    private final String blockOverrideDomain;
    private final String blockOverrideDnsType;
    private final Integer blockOverrideTtl;
    private final String creatorRequestId;
    private final String creationTime;
    private final String modificationTime;
    private final String firewallDomainRedirectionAction;
    private final String qtype;

    private FirewallRule(BuilderImpl builder) {
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.action = builder.action;
        this.blockResponse = builder.blockResponse;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
        this.firewallDomainRedirectionAction = builder.firewallDomainRedirectionAction;
        this.qtype = builder.qtype;
    }

    public final String firewallRuleGroupId() {
        return this.firewallRuleGroupId;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final BlockResponse blockResponse() {
        return BlockResponse.fromValue(this.blockResponse);
    }

    public final String blockResponseAsString() {
        return this.blockResponse;
    }

    public final String blockOverrideDomain() {
        return this.blockOverrideDomain;
    }

    public final BlockOverrideDnsType blockOverrideDnsType() {
        return BlockOverrideDnsType.fromValue(this.blockOverrideDnsType);
    }

    public final String blockOverrideDnsTypeAsString() {
        return this.blockOverrideDnsType;
    }

    public final Integer blockOverrideTtl() {
        return this.blockOverrideTtl;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public final FirewallDomainRedirectionAction firewallDomainRedirectionAction() {
        return FirewallDomainRedirectionAction.fromValue(this.firewallDomainRedirectionAction);
    }

    public final String firewallDomainRedirectionActionAsString() {
        return this.firewallDomainRedirectionAction;
    }

    public final String qtype() {
        return this.qtype;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainRedirectionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qtype());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRule)) {
            return false;
        }
        FirewallRule other = (FirewallRule)obj;
        return Objects.equals(this.firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.blockResponseAsString(), other.blockResponseAsString()) && Objects.equals(this.blockOverrideDomain(), other.blockOverrideDomain()) && Objects.equals(this.blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString()) && Objects.equals(this.blockOverrideTtl(), other.blockOverrideTtl()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime()) && Objects.equals(this.firewallDomainRedirectionActionAsString(), other.firewallDomainRedirectionActionAsString()) && Objects.equals(this.qtype(), other.qtype());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallRule").add("FirewallRuleGroupId", (Object)this.firewallRuleGroupId()).add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("Action", (Object)this.actionAsString()).add("BlockResponse", (Object)this.blockResponseAsString()).add("BlockOverrideDomain", (Object)this.blockOverrideDomain()).add("BlockOverrideDnsType", (Object)this.blockOverrideDnsTypeAsString()).add("BlockOverrideTtl", (Object)this.blockOverrideTtl()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).add("FirewallDomainRedirectionAction", (Object)this.firewallDomainRedirectionActionAsString()).add("Qtype", (Object)this.qtype()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallRuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupId()));
            }
            case "FirewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "BlockResponse": {
                return Optional.ofNullable(clazz.cast(this.blockResponseAsString()));
            }
            case "BlockOverrideDomain": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDomain()));
            }
            case "BlockOverrideDnsType": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDnsTypeAsString()));
            }
            case "BlockOverrideTtl": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideTtl()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
            case "FirewallDomainRedirectionAction": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainRedirectionActionAsString()));
            }
            case "Qtype": {
                return Optional.ofNullable(clazz.cast(this.qtype()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRule, T> g) {
        return obj -> g.apply((FirewallRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firewallRuleGroupId;
        private String firewallDomainListId;
        private String name;
        private Integer priority;
        private String action;
        private String blockResponse;
        private String blockOverrideDomain;
        private String blockOverrideDnsType;
        private Integer blockOverrideTtl;
        private String creatorRequestId;
        private String creationTime;
        private String modificationTime;
        private String firewallDomainRedirectionAction;
        private String qtype;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRule model) {
            this.firewallRuleGroupId(model.firewallRuleGroupId);
            this.firewallDomainListId(model.firewallDomainListId);
            this.name(model.name);
            this.priority(model.priority);
            this.action(model.action);
            this.blockResponse(model.blockResponse);
            this.blockOverrideDomain(model.blockOverrideDomain);
            this.blockOverrideDnsType(model.blockOverrideDnsType);
            this.blockOverrideTtl(model.blockOverrideTtl);
            this.creatorRequestId(model.creatorRequestId);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
            this.firewallDomainRedirectionAction(model.firewallDomainRedirectionAction);
            this.qtype(model.qtype);
        }

        public final String getFirewallRuleGroupId() {
            return this.firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockResponse() {
            return this.blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(BlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return this.blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return this.blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return this.blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getFirewallDomainRedirectionAction() {
            return this.firewallDomainRedirectionAction;
        }

        public final void setFirewallDomainRedirectionAction(String firewallDomainRedirectionAction) {
            this.firewallDomainRedirectionAction = firewallDomainRedirectionAction;
        }

        @Override
        public final Builder firewallDomainRedirectionAction(String firewallDomainRedirectionAction) {
            this.firewallDomainRedirectionAction = firewallDomainRedirectionAction;
            return this;
        }

        @Override
        public final Builder firewallDomainRedirectionAction(FirewallDomainRedirectionAction firewallDomainRedirectionAction) {
            this.firewallDomainRedirectionAction(firewallDomainRedirectionAction == null ? null : firewallDomainRedirectionAction.toString());
            return this;
        }

        public final String getQtype() {
            return this.qtype;
        }

        public final void setQtype(String qtype) {
            this.qtype = qtype;
        }

        @Override
        public final Builder qtype(String qtype) {
            this.qtype = qtype;
            return this;
        }

        public FirewallRule build() {
            return new FirewallRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallRule> {
        public Builder firewallRuleGroupId(String var1);

        public Builder firewallDomainListId(String var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder blockResponse(String var1);

        public Builder blockResponse(BlockResponse var1);

        public Builder blockOverrideDomain(String var1);

        public Builder blockOverrideDnsType(String var1);

        public Builder blockOverrideDnsType(BlockOverrideDnsType var1);

        public Builder blockOverrideTtl(Integer var1);

        public Builder creatorRequestId(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);

        public Builder firewallDomainRedirectionAction(String var1);

        public Builder firewallDomainRedirectionAction(FirewallDomainRedirectionAction var1);

        public Builder qtype(String var1);
    }
}

