/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleTypeOption {
    FORWARD("FORWARD"),
    SYSTEM("SYSTEM"),
    RECURSIVE("RECURSIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleTypeOption> VALUE_MAP;
    private final String value;

    private RuleTypeOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleTypeOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleTypeOption> knownValues() {
        EnumSet<RuleTypeOption> knownValues = EnumSet.allOf(RuleTypeOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleTypeOption.class, RuleTypeOption::toString);
    }
}

