/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainImportOperation;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportFirewallDomainsRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, ImportFirewallDomainsRequest> {
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallDomainListId").getter(ImportFirewallDomainsRequest.getter(ImportFirewallDomainsRequest::firewallDomainListId)).setter(ImportFirewallDomainsRequest.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(ImportFirewallDomainsRequest.getter(ImportFirewallDomainsRequest::operationAsString)).setter(ImportFirewallDomainsRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> DOMAIN_FILE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainFileUrl").getter(ImportFirewallDomainsRequest.getter(ImportFirewallDomainsRequest::domainFileUrl)).setter(ImportFirewallDomainsRequest.setter(Builder::domainFileUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainFileUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_DOMAIN_LIST_ID_FIELD, OPERATION_FIELD, DOMAIN_FILE_URL_FIELD));
    private final String firewallDomainListId;
    private final String operation;
    private final String domainFileUrl;

    private ImportFirewallDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallDomainListId = builder.firewallDomainListId;
        this.operation = builder.operation;
        this.domainFileUrl = builder.domainFileUrl;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final FirewallDomainImportOperation operation() {
        return FirewallDomainImportOperation.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final String domainFileUrl() {
        return this.domainFileUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainFileUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportFirewallDomainsRequest)) {
            return false;
        }
        ImportFirewallDomainsRequest other = (ImportFirewallDomainsRequest)((Object)obj);
        return Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.domainFileUrl(), other.domainFileUrl());
    }

    public final String toString() {
        return ToString.builder((String)"ImportFirewallDomainsRequest").add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Operation", (Object)this.operationAsString()).add("DomainFileUrl", (Object)this.domainFileUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "DomainFileUrl": {
                return Optional.ofNullable(clazz.cast(this.domainFileUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportFirewallDomainsRequest, T> g) {
        return obj -> g.apply((ImportFirewallDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String firewallDomainListId;
        private String operation;
        private String domainFileUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportFirewallDomainsRequest model) {
            super(model);
            this.firewallDomainListId(model.firewallDomainListId);
            this.operation(model.operation);
            this.domainFileUrl(model.domainFileUrl);
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(FirewallDomainImportOperation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getDomainFileUrl() {
            return this.domainFileUrl;
        }

        public final void setDomainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
        }

        @Override
        public final Builder domainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportFirewallDomainsRequest build() {
            return new ImportFirewallDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportFirewallDomainsRequest> {
        public Builder firewallDomainListId(String var1);

        public Builder operation(String var1);

        public Builder operation(FirewallDomainImportOperation var1);

        public Builder domainFileUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

