/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallRule;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse;

public class ListFirewallRulesPublisher
implements SdkPublisher<ListFirewallRulesResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListFirewallRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallRulesPublisher(Route53ResolverAsyncClient client, ListFirewallRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallRulesPublisher(Route53ResolverAsyncClient client, ListFirewallRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallRule> firewallRules() {
        Function<ListFirewallRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRules() != null) {
                return response.firewallRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallRulesResponseFetcher
    implements AsyncPageFetcher<ListFirewallRulesResponse> {
        private ListFirewallRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallRulesResponse> nextPage(ListFirewallRulesResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRulesPublisher.this.client.listFirewallRules(ListFirewallRulesPublisher.this.firstRequest);
            }
            return ListFirewallRulesPublisher.this.client.listFirewallRules((ListFirewallRulesRequest)((Object)ListFirewallRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

