/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse;

public class ListFirewallDomainListsIterable
implements SdkIterable<ListFirewallDomainListsResponse> {
    private final Route53ResolverClient client;
    private final ListFirewallDomainListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallDomainListsIterable(Route53ResolverClient client, ListFirewallDomainListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFirewallDomainListsResponseFetcher();
    }

    public Iterator<ListFirewallDomainListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallDomainListMetadata> firewallDomainLists() {
        Function<ListFirewallDomainListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallDomainLists() != null) {
                return response.firewallDomainLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallDomainListsResponseFetcher
    implements SyncPageFetcher<ListFirewallDomainListsResponse> {
        private ListFirewallDomainListsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallDomainListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallDomainListsResponse nextPage(ListFirewallDomainListsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallDomainListsIterable.this.client.listFirewallDomainLists(ListFirewallDomainListsIterable.this.firstRequest);
            }
            return ListFirewallDomainListsIterable.this.client.listFirewallDomainLists((ListFirewallDomainListsRequest)((Object)ListFirewallDomainListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

