/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ResolverAutodefinedReverseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResolverConfig.getter(ResolverConfig::id)).setter(ResolverConfig.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResolverConfig.getter(ResolverConfig::resourceId)).setter(ResolverConfig.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ResolverConfig.getter(ResolverConfig::ownerId)).setter(ResolverConfig.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> AUTODEFINED_REVERSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutodefinedReverse").getter(ResolverConfig.getter(ResolverConfig::autodefinedReverseAsString)).setter(ResolverConfig.setter(Builder::autodefinedReverse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutodefinedReverse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ID_FIELD, OWNER_ID_FIELD, AUTODEFINED_REVERSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resourceId;
    private final String ownerId;
    private final String autodefinedReverse;

    private ResolverConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceId = builder.resourceId;
        this.ownerId = builder.ownerId;
        this.autodefinedReverse = builder.autodefinedReverse;
    }

    public final String id() {
        return this.id;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final ResolverAutodefinedReverseStatus autodefinedReverse() {
        return ResolverAutodefinedReverseStatus.fromValue(this.autodefinedReverse);
    }

    public final String autodefinedReverseAsString() {
        return this.autodefinedReverse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autodefinedReverseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverConfig)) {
            return false;
        }
        ResolverConfig other = (ResolverConfig)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.autodefinedReverseAsString(), other.autodefinedReverseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResolverConfig").add("Id", (Object)this.id()).add("ResourceId", (Object)this.resourceId()).add("OwnerId", (Object)this.ownerId()).add("AutodefinedReverse", (Object)this.autodefinedReverseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "AutodefinedReverse": {
                return Optional.ofNullable(clazz.cast(this.autodefinedReverseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverConfig, T> g) {
        return obj -> g.apply((ResolverConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceId;
        private String ownerId;
        private String autodefinedReverse;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverConfig model) {
            this.id(model.id);
            this.resourceId(model.resourceId);
            this.ownerId(model.ownerId);
            this.autodefinedReverse(model.autodefinedReverse);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getAutodefinedReverse() {
            return this.autodefinedReverse;
        }

        public final void setAutodefinedReverse(String autodefinedReverse) {
            this.autodefinedReverse = autodefinedReverse;
        }

        @Override
        @Transient
        public final Builder autodefinedReverse(String autodefinedReverse) {
            this.autodefinedReverse = autodefinedReverse;
            return this;
        }

        @Override
        @Transient
        public final Builder autodefinedReverse(ResolverAutodefinedReverseStatus autodefinedReverse) {
            this.autodefinedReverse(autodefinedReverse == null ? null : autodefinedReverse.toString());
            return this;
        }

        public ResolverConfig build() {
            return new ResolverConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverConfig> {
        public Builder id(String var1);

        public Builder resourceId(String var1);

        public Builder ownerId(String var1);

        public Builder autodefinedReverse(String var1);

        public Builder autodefinedReverse(ResolverAutodefinedReverseStatus var1);
    }
}

