/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlockResponse {
    NODATA("NODATA"),
    NXDOMAIN("NXDOMAIN"),
    OVERRIDE("OVERRIDE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BlockResponse(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockResponse fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BlockResponse.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockResponse> knownValues() {
        return Stream.of(BlockResponse.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

