/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociationListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverQueryLogConfigAssociationsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverQueryLogConfigAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverQueryLogConfigAssociationsResponse.getter(ListResolverQueryLogConfigAssociationsResponse::nextToken)).setter(ListResolverQueryLogConfigAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(ListResolverQueryLogConfigAssociationsResponse.getter(ListResolverQueryLogConfigAssociationsResponse::totalCount)).setter(ListResolverQueryLogConfigAssociationsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<Integer> TOTAL_FILTERED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFilteredCount").getter(ListResolverQueryLogConfigAssociationsResponse.getter(ListResolverQueryLogConfigAssociationsResponse::totalFilteredCount)).setter(ListResolverQueryLogConfigAssociationsResponse.setter(Builder::totalFilteredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFilteredCount").build()}).build();
    private static final SdkField<List<ResolverQueryLogConfigAssociation>> RESOLVER_QUERY_LOG_CONFIG_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverQueryLogConfigAssociations").getter(ListResolverQueryLogConfigAssociationsResponse.getter(ListResolverQueryLogConfigAssociationsResponse::resolverQueryLogConfigAssociations)).setter(ListResolverQueryLogConfigAssociationsResponse.setter(Builder::resolverQueryLogConfigAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverQueryLogConfigAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD, TOTAL_FILTERED_COUNT_FIELD, RESOLVER_QUERY_LOG_CONFIG_ASSOCIATIONS_FIELD));
    private final String nextToken;
    private final Integer totalCount;
    private final Integer totalFilteredCount;
    private final List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations;

    private ListResolverQueryLogConfigAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
        this.totalFilteredCount = builder.totalFilteredCount;
        this.resolverQueryLogConfigAssociations = builder.resolverQueryLogConfigAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public final Integer totalFilteredCount() {
        return this.totalFilteredCount;
    }

    public final boolean hasResolverQueryLogConfigAssociations() {
        return this.resolverQueryLogConfigAssociations != null && !(this.resolverQueryLogConfigAssociations instanceof SdkAutoConstructList);
    }

    public final List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations() {
        return this.resolverQueryLogConfigAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFilteredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolverQueryLogConfigAssociations() ? this.resolverQueryLogConfigAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverQueryLogConfigAssociationsResponse)) {
            return false;
        }
        ListResolverQueryLogConfigAssociationsResponse other = (ListResolverQueryLogConfigAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.totalFilteredCount(), other.totalFilteredCount()) && this.hasResolverQueryLogConfigAssociations() == other.hasResolverQueryLogConfigAssociations() && Objects.equals(this.resolverQueryLogConfigAssociations(), other.resolverQueryLogConfigAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverQueryLogConfigAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).add("TotalFilteredCount", (Object)this.totalFilteredCount()).add("ResolverQueryLogConfigAssociations", this.hasResolverQueryLogConfigAssociations() ? this.resolverQueryLogConfigAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "TotalFilteredCount": {
                return Optional.ofNullable(clazz.cast(this.totalFilteredCount()));
            }
            case "ResolverQueryLogConfigAssociations": {
                return Optional.ofNullable(clazz.cast(this.resolverQueryLogConfigAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverQueryLogConfigAssociationsResponse, T> g) {
        return obj -> g.apply((ListResolverQueryLogConfigAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer totalCount;
        private Integer totalFilteredCount;
        private List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverQueryLogConfigAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
            this.totalFilteredCount(model.totalFilteredCount);
            this.resolverQueryLogConfigAssociations(model.resolverQueryLogConfigAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public final Integer getTotalFilteredCount() {
            return this.totalFilteredCount;
        }

        @Override
        public final Builder totalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
            return this;
        }

        public final void setTotalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
        }

        public final List<ResolverQueryLogConfigAssociation.Builder> getResolverQueryLogConfigAssociations() {
            List<ResolverQueryLogConfigAssociation.Builder> result = ResolverQueryLogConfigAssociationListCopier.copyToBuilder(this.resolverQueryLogConfigAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverQueryLogConfigAssociations(Collection<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations = ResolverQueryLogConfigAssociationListCopier.copy(resolverQueryLogConfigAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigAssociations(ResolverQueryLogConfigAssociation ... resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations(Arrays.asList(resolverQueryLogConfigAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigAssociations(Consumer<ResolverQueryLogConfigAssociation.Builder> ... resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations(Stream.of(resolverQueryLogConfigAssociations).map(c -> (ResolverQueryLogConfigAssociation)((ResolverQueryLogConfigAssociation.Builder)ResolverQueryLogConfigAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverQueryLogConfigAssociations(Collection<ResolverQueryLogConfigAssociation.BuilderImpl> resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations = ResolverQueryLogConfigAssociationListCopier.copyFromBuilder(resolverQueryLogConfigAssociations);
        }

        @Override
        public ListResolverQueryLogConfigAssociationsResponse build() {
            return new ListResolverQueryLogConfigAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverQueryLogConfigAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);

        public Builder totalFilteredCount(Integer var1);

        public Builder resolverQueryLogConfigAssociations(Collection<ResolverQueryLogConfigAssociation> var1);

        public Builder resolverQueryLogConfigAssociations(ResolverQueryLogConfigAssociation ... var1);

        public Builder resolverQueryLogConfigAssociations(Consumer<ResolverQueryLogConfigAssociation.Builder> ... var1);
    }
}

