/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig;
import software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfigListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverDnssecConfigsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverDnssecConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverDnssecConfigsResponse.getter(ListResolverDnssecConfigsResponse::nextToken)).setter(ListResolverDnssecConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ResolverDnssecConfig>> RESOLVER_DNSSEC_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverDnssecConfigs").getter(ListResolverDnssecConfigsResponse.getter(ListResolverDnssecConfigsResponse::resolverDnssecConfigs)).setter(ListResolverDnssecConfigsResponse.setter(Builder::resolverDnssecConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverDnssecConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverDnssecConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOLVER_DNSSEC_CONFIGS_FIELD));
    private final String nextToken;
    private final List<ResolverDnssecConfig> resolverDnssecConfigs;

    private ListResolverDnssecConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resolverDnssecConfigs = builder.resolverDnssecConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResolverDnssecConfigs() {
        return this.resolverDnssecConfigs != null && !(this.resolverDnssecConfigs instanceof SdkAutoConstructList);
    }

    public final List<ResolverDnssecConfig> resolverDnssecConfigs() {
        return this.resolverDnssecConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolverDnssecConfigs() ? this.resolverDnssecConfigs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverDnssecConfigsResponse)) {
            return false;
        }
        ListResolverDnssecConfigsResponse other = (ListResolverDnssecConfigsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResolverDnssecConfigs() == other.hasResolverDnssecConfigs() && Objects.equals(this.resolverDnssecConfigs(), other.resolverDnssecConfigs());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverDnssecConfigsResponse").add("NextToken", (Object)this.nextToken()).add("ResolverDnssecConfigs", this.hasResolverDnssecConfigs() ? this.resolverDnssecConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResolverDnssecConfigs": {
                return Optional.ofNullable(clazz.cast(this.resolverDnssecConfigs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverDnssecConfigsResponse, T> g) {
        return obj -> g.apply((ListResolverDnssecConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResolverDnssecConfig> resolverDnssecConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverDnssecConfigsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resolverDnssecConfigs(model.resolverDnssecConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<ResolverDnssecConfig.Builder> getResolverDnssecConfigs() {
            List<ResolverDnssecConfig.Builder> result = ResolverDnssecConfigListCopier.copyToBuilder(this.resolverDnssecConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverDnssecConfigs(Collection<ResolverDnssecConfig> resolverDnssecConfigs) {
            this.resolverDnssecConfigs = ResolverDnssecConfigListCopier.copy(resolverDnssecConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverDnssecConfigs(ResolverDnssecConfig ... resolverDnssecConfigs) {
            this.resolverDnssecConfigs(Arrays.asList(resolverDnssecConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverDnssecConfigs(Consumer<ResolverDnssecConfig.Builder> ... resolverDnssecConfigs) {
            this.resolverDnssecConfigs(Stream.of(resolverDnssecConfigs).map(c -> (ResolverDnssecConfig)((ResolverDnssecConfig.Builder)ResolverDnssecConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverDnssecConfigs(Collection<ResolverDnssecConfig.BuilderImpl> resolverDnssecConfigs) {
            this.resolverDnssecConfigs = ResolverDnssecConfigListCopier.copyFromBuilder(resolverDnssecConfigs);
        }

        @Override
        public ListResolverDnssecConfigsResponse build() {
            return new ListResolverDnssecConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverDnssecConfigsResponse> {
        public Builder nextToken(String var1);

        public Builder resolverDnssecConfigs(Collection<ResolverDnssecConfig> var1);

        public Builder resolverDnssecConfigs(ResolverDnssecConfig ... var1);

        public Builder resolverDnssecConfigs(Consumer<ResolverDnssecConfig.Builder> ... var1);
    }
}

