/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAddressUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAddressUpdate> {
    private static final SdkField<String> IP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpId").getter(IpAddressUpdate.getter(IpAddressUpdate::ipId)).setter(IpAddressUpdate.setter(Builder::ipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(IpAddressUpdate.getter(IpAddressUpdate::subnetId)).setter(IpAddressUpdate.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(IpAddressUpdate.getter(IpAddressUpdate::ip)).setter(IpAddressUpdate.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ID_FIELD, SUBNET_ID_FIELD, IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipId;
    private final String subnetId;
    private final String ip;

    private IpAddressUpdate(BuilderImpl builder) {
        this.ipId = builder.ipId;
        this.subnetId = builder.subnetId;
        this.ip = builder.ip;
    }

    public final String ipId() {
        return this.ipId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String ip() {
        return this.ip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressUpdate)) {
            return false;
        }
        IpAddressUpdate other = (IpAddressUpdate)obj;
        return Objects.equals(this.ipId(), other.ipId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.ip(), other.ip());
    }

    public final String toString() {
        return ToString.builder((String)"IpAddressUpdate").add("IpId", (Object)this.ipId()).add("SubnetId", (Object)this.subnetId()).add("Ip", (Object)this.ip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpId": {
                return Optional.ofNullable(clazz.cast(this.ipId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAddressUpdate, T> g) {
        return obj -> g.apply((IpAddressUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipId;
        private String subnetId;
        private String ip;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressUpdate model) {
            this.ipId(model.ipId);
            this.subnetId(model.subnetId);
            this.ip(model.ip);
        }

        public final String getIpId() {
            return this.ipId;
        }

        @Override
        public final Builder ipId(String ipId) {
            this.ipId = ipId;
            return this;
        }

        public final void setIpId(String ipId) {
            this.ipId = ipId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIp() {
            return this.ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public IpAddressUpdate build() {
            return new IpAddressUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAddressUpdate> {
        public Builder ipId(String var1);

        public Builder subnetId(String var1);

        public Builder ip(String var1);
    }
}

