/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFirewallConfigRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateFirewallConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(UpdateFirewallConfigRequest.getter(UpdateFirewallConfigRequest::resourceId)).setter(UpdateFirewallConfigRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> FIREWALL_FAIL_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallFailOpen").getter(UpdateFirewallConfigRequest.getter(UpdateFirewallConfigRequest::firewallFailOpenAsString)).setter(UpdateFirewallConfigRequest.setter(Builder::firewallFailOpen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallFailOpen").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, FIREWALL_FAIL_OPEN_FIELD));
    private final String resourceId;
    private final String firewallFailOpen;

    private UpdateFirewallConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.firewallFailOpen = builder.firewallFailOpen;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final FirewallFailOpenStatus firewallFailOpen() {
        return FirewallFailOpenStatus.fromValue(this.firewallFailOpen);
    }

    public final String firewallFailOpenAsString() {
        return this.firewallFailOpen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallFailOpenAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallConfigRequest)) {
            return false;
        }
        UpdateFirewallConfigRequest other = (UpdateFirewallConfigRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.firewallFailOpenAsString(), other.firewallFailOpenAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFirewallConfigRequest").add("ResourceId", (Object)this.resourceId()).add("FirewallFailOpen", (Object)this.firewallFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "FirewallFailOpen": {
                return Optional.ofNullable(clazz.cast(this.firewallFailOpenAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallConfigRequest, T> g) {
        return obj -> g.apply((UpdateFirewallConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String firewallFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallConfigRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.firewallFailOpen(model.firewallFailOpen);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getFirewallFailOpen() {
            return this.firewallFailOpen;
        }

        @Override
        public final Builder firewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
            return this;
        }

        @Override
        public final Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen) {
            this.firewallFailOpen(firewallFailOpen == null ? null : firewallFailOpen.toString());
            return this;
        }

        public final void setFirewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallConfigRequest build() {
            return new UpdateFirewallConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFirewallConfigRequest> {
        public Builder resourceId(String var1);

        public Builder firewallFailOpen(String var1);

        public Builder firewallFailOpen(FirewallFailOpenStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

