/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html"
 * >CreateResolverEndpoint</a> request, the IP address that DNS queries originate from (for outbound endpoints) or that
 * you forward DNS queries to (for inbound endpoints). <code>IpAddressRequest</code> also includes the ID of the subnet
 * that contains the IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAddressRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<IpAddressRequest.Builder, IpAddressRequest> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(IpAddressRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(IpAddressRequest::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subnetId;

    private final String ip;

    private IpAddressRequest(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.ip = builder.ip;
    }

    /**
     * <p>
     * The ID of the subnet that contains the IP address.
     * </p>
     * 
     * @return The ID of the subnet that contains the IP address.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The IP address that you want to use for DNS queries.
     * </p>
     * 
     * @return The IP address that you want to use for DNS queries.
     */
    public final String ip() {
        return ip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddressRequest)) {
            return false;
        }
        IpAddressRequest other = (IpAddressRequest) obj;
        return Objects.equals(subnetId(), other.subnetId()) && Objects.equals(ip(), other.ip());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAddressRequest").add("SubnetId", subnetId()).add("Ip", ip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAddressRequest, T> g) {
        return obj -> g.apply((IpAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAddressRequest> {
        /**
         * <p>
         * The ID of the subnet that contains the IP address.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet that contains the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IP address that you want to use for DNS queries.
         * </p>
         * 
         * @param ip
         *        The IP address that you want to use for DNS queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);
    }

    static final class BuilderImpl implements Builder {
        private String subnetId;

        private String ip;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAddressRequest model) {
            subnetId(model.subnetId);
            ip(model.ip);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIp() {
            return ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public IpAddressRequest build() {
            return new IpAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
